package bodybuilder.test.jsp;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.jdom.Element;

import bodybuilder.builder.servlet.RequestBuilder;
import bodybuilder.builder.servlet.ServletContextBuilder;
import bodybuilder.builder.servlet.SessionBuilder;
import bodybuilder.test.TestCaseXML;
import bodybuilder.util.FileUtils;
import bodybuilder.util.Utils;
import bodybuilder.util.jdom.JDOMUtils;

/**
 * JSPテストケースXML
 */
public class JSPTestCaseXML extends TestCaseXML implements Serializable {

    /////////////////////////////////////////////////////////////////
    // constant field

    /**
     * セッターインジェクション(Type 2)
     */
    public static final int SETTER_INJECTION = 2;

    /**
     * コンストラクタインジェクション(Type 3)
     */
    public static final int CONSTRUCTOR_INJECTION = 3;

    /////////////////////////////////////////////////////////////////
    // variable field

    /**
     * パス
     */
    protected String path = null;

    /**
     * 出力先
     */
    protected String output = null;

    /**
     * サーブレットコンテキスト要素
     */
    protected Element contextElem = null;

    /**
     * リクエスト要素
     */
    protected Element requestElem = null;

    /**
     * セッション要素
     */
    protected Element sessionElem = null;

    /////////////////////////////////////////////////////////////////
    // build method

    /**
     * テストケースXMLを構築する。
     */
    protected void build() {
        super.build();
        // パスを読み込む。
        path = JDOMUtils.getRequiredChild(root, "path").getTextTrim();
        path = Utils.formatSlash(path);
        // 出力先を読み込む。
        output = JDOMUtils.getRequiredChild(root, "output").getTextTrim();

        // 入力値を読み込む。
        Element input = root.getChild("input");

        if (input != null) {
            loadInput(input);
        }
    }

    /**
     * 入力値を読み込む。
     * 
     * @param input 入力値要素
     */
    private void loadInput(Element input) {
        // サーブレットコンテキストを取得。
        contextElem = input.getChild("servletcontext");
        // リクエストを取得。
        requestElem = input.getChild("request");
        // セッションを取得。
        sessionElem = input.getChild("session");
    }

    /////////////////////////////////////////////////////////////////
    // property

    /**
     * パスを取得する。
     * 
     * @return パス
     */
    public String getPath() {
        return path;
    }

    /**
     * 出力先を取得する。
     * 
     * @return 出力先
     */
    public String getOutput() {
        if (output == null) {
            return file.getAbsolutePath() + ".html";
        } else if (!FileUtils.isFullPath(output)) {
            return file.getParent() + File.separator + output;
        } else {
            return output;
        }
    }

    /**
     * パラメータを取得する。
     * 
     * @return パラメータ
     */
    public Map getParama() {
        if (requestElem != null) {
            return RequestBuilder.getParams(requestElem);
        } else {
            return new HashMap();
        }
    }

    /////////////////////////////////////////////////////////////////
    // setup

    /**
     * サーブレットコンテキストをセットアップする。
     * 
     * @param context サーブレットコンテキスト
     */
    public void setupServletContext(ServletContext context) {
        if (contextElem != null) {
            ServletContextBuilder.setup(contextElem, context);
        }
    }

    /**
     * リクエストをセットアップする。
     * 
     * @param request リクエスト
     */
    public void setupRequest(HttpServletRequest request) {
        if (requestElem != null) {
            RequestBuilder.setup(requestElem, request);
        }
    }

    /**
     * セッションをセットアップする。
     * 
     * @param session セッション
     */
    public void setupSession(HttpSession session) {
        if (sessionElem != null) {
            SessionBuilder.setup(sessionElem, session);
        }
    }

}