package bodybuilder.test.jsp;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.test.XMLTestCase;
import bodybuilder.test.TestCaseXML;
import bodybuilder.util.Serializer;

/**
 * JSPテストケース
 */
public class JSPTestCase extends XMLTestCase {

    /**
     * テストケースXMLのパラメータ名
     */
    public static final String TESTCASE_XML_PARAM_NAME = "_"
            + JSPTestCase.class.getName() + "_testcase_xml";

    /**
     * JSPテストケースXML
     */
    protected JSPTestCaseXML xml = null;

    /**
     * JSPテストケースXMLをセットする。
     * 
     * @param xml JSPテストケースXML
     */
    protected void setXML(TestCaseXML xml) {
        this.xml = (JSPTestCaseXML) xml;
    }

    /**
     * テストを実行する。
     */
    protected void runTest() {
        info("'" + getName() + "' is started .");
        debug("description is:" + Config.NL + xml.getDescription());

        // サーバルートを取得。
        String serverRoot = Config.getServerRoot();
        debug("server root is '" + serverRoot + "'.");

        // コンテキストルートを取得。
        String contextRoot = Config.getContextRoot();
        debug("context root is '" + contextRoot + "'.");

        // パスを取得。
        String path = serverRoot + contextRoot + xml.getPath();
        debug("request path is '" + path + "'.");

        // リクエストの文字セットを取得。
        String charset = Config.getRequestCharset();
        debug("request charset is '" + charset + "'.");

        // TODO 文字化けに対応すること。
        HttpUnitOptions.setDefaultCharacterSet(charset);
        HttpUnitOptions.setPostIncludesCharset(true);

        WebConversation wc = new WebConversation();

        // POSTリクエストを生成。
        String redirector = serverRoot + contextRoot
                + Config.getRedirectorPath();
        debug("create post method for redirector '" + redirector + "'.");
        WebRequest req = new PostMethodWebRequest(redirector);

        // パラメータをセット。
        debug("setup request parameters.");
        Map params = xml.getParama();
        Iterator names = params.keySet().iterator();

        while (names.hasNext()) {
            String name = (String) names.next();
            String[] values = (String[]) params.get(name);

            if (values.length == 1) {
                debug("add patameter '" + name + "'(" + values[0] + ").");
            } else {
                debug("add patameter '" + name + "'(" + Arrays.asList(values)
                        + ").");
            }

            req.setParameter(name, values);
        }

        // パラメータにテストケースXMLをセット。
        debug("set testcase xml to patameter");
        String encoded = Serializer.serialize(xml);
        req.setParameter(TESTCASE_XML_PARAM_NAME, encoded);

        // リクエストを投げる。
        debug("request to '" + redirector + "'.");
        WebResponse res = null;

        try {
            res = wc.getResponse(req);
        } catch (Exception e) {
            e.printStackTrace();
            throw new BodyBuilderException("it was not able to request '"
                    + redirector + "'.", e);
        }

        // 出力先を取得。
        String output = xml.getOutput();
        debug("output is '" + output + "'.");
        String resText = null;

        try {
            resText = res.getText();
        } catch (IOException e) {
            throw new BodyBuilderException("could not get response text.", e);
        }

        debug("response text is:" + Config.NL + resText);

        // ファイルを出力。
        debug("output file.");

        try {
            FileWriter writer = new FileWriter(output);
            writer.write(resText);
            writer.flush();
            writer.close();
        } catch (IOException e) {
            throw new BodyBuilderException("could not output file.", e);
        }

        info("test was ended.");
    }

}