package bodybuilder.test.jsp;

import bodybuilder.util.Utils;

/**
 * 設定
 */
public class Config extends bodybuilder.util.Config {

    /**
     * JSPテストケースのプロパティのプリフィックス
     */
    protected static final String JSP_TESTCASE_PROP_PREFIX = TEST_PROP_KEY_PREFIX
            + "jsptestcase.";

    /**
     * サーバルートを取得する。
     * 
     * @return サーバルート
     */
    public static String getServerRoot() {
        String contextRoot = getRequiredProperty(JSP_TESTCASE_PROP_PREFIX
                + "server.root");

        return Utils.formatSlash(contextRoot, false, false);
    }

    /**
     * コンテキストルートを取得する。
     * 
     * @return コンテキストルート
     */
    public static String getContextRoot() {
        String contextRoot = getRequiredProperty(JSP_TESTCASE_PROP_PREFIX
                + "context.root");

        return Utils.formatSlash(contextRoot);
    }

    /**
     * リダイレクタのパスを取得する。
     * 
     * @return リダイレクタのパス
     */
    public static String getRedirectorPath() {
        String path = getRequiredProperty(JSP_TESTCASE_PROP_PREFIX
                + "redirector.path");

        return Utils.formatSlash(path);
    }

    /**
     * リクエストの文字セットを取得する。
     * 
     * @return リクエストの文字セット
     */
    public static String getRequestCharset() {
        String charset = getProperty(JSP_TESTCASE_PROP_PREFIX
                + "request.charset");

        // 取得できない場合はShift_JIS。
        if (charset == null) {
            charset = "Shift_JIS";
        }

        return charset;
    }

}