package sample.builder.extension;

import org.jdom.Element;

import sample.object.UserDefined2;

import bodybuilder.builder.Builder;
import bodybuilder.builder.argument.Argument;
import bodybuilder.util.jdom.JDOMUtils;

/**
 * ユーザ定義オブジェクト２ビルダー
 */
public class UserDefined2Builder extends Builder {

    /**
     * ユーザ定義オブジェクト２を取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return ユーザ定義オブジェクト２
     */
    public Object getMuscle(Element element, Argument constructor) {
        // <message>を取得。
        Element msgElem = element.getChild("message");

        String message = null;

        // <message>の値を取得。
        if (msgElem != null) {
            message = JDOMUtils.getRequiredAttrValue(msgElem, "value");
        }

        // <value>を取得。
        Element valElem = element.getChild("value");

        Object value = null;

        // <value>の値を取得。
        if (valElem != null) {
            value = getValue(valElem);
        }

        // ユーザ定義オブジェクト２を生成。
        UserDefined2 userDefined2 = new UserDefined2(message, value);

        // ユーザ定義オブジェクト２を返す。
        return userDefined2;
    }

}