/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletObjectUtils {
    public static Map getRequestParameters(HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            if (values.length == 1) {
                params.put(name, values[0]);
                continue;
            }
            params.put(name, values);
        }
        return params;
    }

    public static Map getRequestAttributes(HttpServletRequest request) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = request.getAttribute(name);
            attributes.put(name, value);
        }
        return attributes;
    }

    public static Map getSessionAttributes(HttpSession session) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = session.getAttribute(name);
            attributes.put(name, value);
        }
        return attributes;
    }

    public static Map getServletContextAttributes(ServletContext context) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration names = context.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = context.getAttribute(name);
            attributes.put(name, value);
        }
        return attributes;
    }
}

