/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util;

import bodybuilder.exception.BodyBuilderException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ObjectUtils {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public static Object getObject(String type) {
        return ObjectUtils.getObject(null, type);
    }

    public static Object getObject(String value, String type) {
        if (type == null || type.equals((class$java$lang$String == null ? (class$java$lang$String = ObjectUtils.class$("java.lang.String")) : class$java$lang$String).getName())) {
            return value;
        }
        if (ObjectUtils.isPrimitive(type)) {
            return ObjectUtils.getPrimitiveWrapperInstance(value, type);
        }
        if (value != null) {
            return ObjectUtils.getInstance(type, new Class[]{class$java$lang$String == null ? (class$java$lang$String = ObjectUtils.class$("java.lang.String")) : class$java$lang$String}, new Object[]{value});
        }
        return ObjectUtils.getInstance(type, new Class[0], new Object[0]);
    }

    public static Object getObject(Class type) {
        return ObjectUtils.getObject(null, type);
    }

    public static Object getObject(String value, Class type) {
        if (type == null || type.equals((class$java$lang$String == null ? (class$java$lang$String = ObjectUtils.class$("java.lang.String")) : class$java$lang$String).getName())) {
            return value;
        }
        if (value != null) {
            return ObjectUtils.getInstance(type, new Class[]{class$java$lang$String == null ? (class$java$lang$String = ObjectUtils.class$("java.lang.String")) : class$java$lang$String}, new Object[]{value});
        }
        return ObjectUtils.getInstance(type, new Class[0], new Object[0]);
    }

    public static boolean isPrimitive(String type) {
        boolean primitive = false;
        if ("bool".equals(type) || "boolean".equals(type)) {
            primitive = true;
        } else if ("byte".equals(type)) {
            primitive = true;
        } else if ("char".equals(type) || "character".equals(type)) {
            primitive = true;
        } else if ("short".equals(type)) {
            primitive = true;
        } else if ("int".equals(type) || "integer".equals(type)) {
            primitive = true;
        } else if ("long".equals(type)) {
            primitive = true;
        } else if ("float".equals(type)) {
            primitive = true;
        } else if ("double".equals(type)) {
            primitive = true;
        }
        return primitive;
    }

    public static Object getPrimitiveWrapperInstance(String value, String type) {
        Comparable<Boolean> obj = null;
        if ("bool".equals(type) || "boolean".equals(type)) {
            obj = Boolean.valueOf(value);
        } else if ("byte".equals(type)) {
            obj = Byte.valueOf(value);
        } else if ("char".equals(type) || "character".equals(type)) {
            obj = new Character((char)Integer.parseInt(value));
        } else if ("short".equals(type)) {
            obj = Short.valueOf(value);
        } else if ("int".equals(type) || "integer".equals(type)) {
            obj = Integer.valueOf(value);
        } else if ("long".equals(type)) {
            obj = Long.valueOf(value);
        } else if ("float".equals(type)) {
            obj = Float.valueOf(value);
        } else if ("double".equals(type)) {
            obj = Double.valueOf(value);
        }
        return obj;
    }

    public static Object getInstance(String type, Class[] classes, Object[] arguments) {
        Class clazz = ObjectUtils.getClass(type);
        return ObjectUtils.getInstance(clazz, classes, arguments);
    }

    public static Object getInstance(Class clazz, Class[] classes, Object[] arguments) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(classes);
            constructor.setAccessible(true);
            return constructor.newInstance(arguments);
        }
        catch (SecurityException e) {
            throw new BodyBuilderException(e);
        }
        catch (NoSuchMethodException e) {
            throw new BodyBuilderException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BodyBuilderException(e);
        }
        catch (InstantiationException e) {
            throw new BodyBuilderException(e);
        }
        catch (IllegalAccessException e) {
            throw new BodyBuilderException(e);
        }
        catch (InvocationTargetException e) {
            throw new BodyBuilderException(e);
        }
    }

    public static Class getClass(String type) {
        try {
            if (ObjectUtils.isPrimitive(type)) {
                return ObjectUtils.getPrimitiveClass(type);
            }
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new BodyBuilderException(e);
        }
    }

    public static Class getPrimitiveClass(String type) {
        Class<Comparable<Boolean>> clazz = null;
        if ("bool".equals(type) || "boolean".equals(type)) {
            clazz = Boolean.TYPE;
        } else if ("byte".equals(type)) {
            clazz = Byte.TYPE;
        } else if ("char".equals(type) || "character".equals(type)) {
            clazz = Character.TYPE;
        } else if ("short".equals(type)) {
            clazz = Short.TYPE;
        } else if ("int".equals(type) || "integer".equals(type)) {
            clazz = Integer.TYPE;
        } else if ("long".equals(type)) {
            clazz = Long.TYPE;
        } else if ("float".equals(type)) {
            clazz = Float.TYPE;
        } else if ("double".equals(type)) {
            clazz = Double.TYPE;
        }
        return clazz;
    }

    public static String getName(Object object, boolean omit) {
        if (object == null) {
            return "null";
        }
        return ObjectUtils.getName(object.getClass(), omit);
    }

    public static String getName(Class clazz, boolean omit) {
        String className = null;
        className = clazz.isArray() ? clazz.getComponentType().getName() + "[]" : clazz.getName();
        if (omit) {
            className = ObjectUtils.omit(className);
        }
        if (Proxy.isProxyClass(clazz)) {
            StringBuffer proxyName = new StringBuffer();
            Class<?>[] interfaces = clazz.getInterfaces();
            proxyName.append(className);
            proxyName.append("(");
            for (int i = 0; i < interfaces.length; ++i) {
                String interfaceName = interfaces[i].getName();
                proxyName.append(ObjectUtils.omit(interfaceName));
                if (i <= 0) continue;
                proxyName.append(",");
            }
            proxyName.append(")");
            className = proxyName.toString();
        }
        return className;
    }

    private static String omit(String className) {
        int pos = className.lastIndexOf(46);
        if (pos > 0) {
            className = className.substring(pos + 1);
        }
        return className;
    }

    public static String getSize(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return String.valueOf(Array.getLength(object));
        }
        Method method = null;
        try {
            method = clazz.getMethod("size", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        try {
            if (method == null) {
                method = clazz.getMethod("length", new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        if (method == null) {
            return null;
        }
        String size = null;
        try {
            Object ret = method.invoke(object, new Object[0]);
            if (ret != null) {
                size = ret.toString();
            }
        }
        catch (NumberFormatException e) {
            size = null;
        }
        catch (IllegalAccessException e) {
            size = null;
        }
        catch (InvocationTargetException e) {
            size = null;
        }
        return size;
    }

    public static String getInfo(Object object) {
        return ObjectUtils.getInfo(object, false);
    }

    public static String getInfo(Object object, boolean appendValue) {
        if (object == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(ObjectUtils.getName(object, true));
        String size = ObjectUtils.getSize(object);
        if (size != null) {
            buffer.append("(" + size + ")");
        }
        if (appendValue) {
            buffer.append(" \"");
            buffer.append(object.toString());
            buffer.append("\"");
        }
        return buffer.toString();
    }

    public static List getClassNames(Object object) {
        return ObjectUtils.getClassNames(object, false);
    }

    public static List getClassNames(Object object, boolean isReverse) {
        if (object == null) {
            ArrayList<String> classNames = new ArrayList<String>();
            classNames.add("null");
            return classNames;
        }
        return ObjectUtils.getClassNames(object.getClass(), isReverse);
    }

    public static List getClassNames(Class clazz) {
        return ObjectUtils.getClassNames(clazz, false);
    }

    public static List getClassNames(Class clazz, boolean isReverse) {
        ArrayList<String> classNames = new ArrayList<String>();
        Class cls = clazz;
        if (clazz.isPrimitive()) {
            classNames.add("primitive");
            return classNames;
        }
        if (clazz.isArray()) {
            classNames.add("array");
            return classNames;
        }
        String objectClassName = (class$java$lang$Object == null ? (class$java$lang$Object = ObjectUtils.class$("java.lang.Object")) : class$java$lang$Object).getName();
        ArrayList interfaceNames = new ArrayList();
        while (!cls.getName().equals(objectClassName)) {
            classNames.add(cls.getName());
            ObjectUtils.addInterfaceNames(cls, interfaceNames);
            cls = cls.getSuperclass();
        }
        classNames.addAll(interfaceNames);
        return classNames;
    }

    private static void addInterfaceNames(Class clazz, List names) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String interfaceName = interfaces[i].getName();
            if (names.contains(interfaceName)) continue;
            names.add(interfaceName);
            ObjectUtils.addInterfaceNames(interfaces[i], names);
        }
    }

    public static Method getMethod(Object object, String name, Class[] classes) {
        if (object == null) {
            throw new BodyBuilderException("object that '" + name + "' defined is null.");
        }
        return ObjectUtils.getMethod(object.getClass(), name, classes);
    }

    public static Method getMethod(Class clazz, String name, Class[] classes) {
        try {
            Method method = null;
            try {
                method = clazz.getMethod(name, classes);
            }
            catch (NoSuchMethodException e) {
                method = clazz.getDeclaredMethod(name, classes);
            }
            return method;
        }
        catch (SecurityException e) {
            throw new BodyBuilderException("cannot get method '" + name + " " + Arrays.asList(classes) + "' as '" + clazz.getName() + "'.", e);
        }
        catch (NoSuchMethodException e) {
            throw new BodyBuilderException("cannot get method '" + name + " " + Arrays.asList(classes) + "' as '" + clazz.getName() + "'.", e);
        }
    }

    public static Object invokeMethod(String type, String name, Class[] classes, Object[] arguments) {
        return ObjectUtils.invokeMethod(ObjectUtils.getClass(type), null, name, classes, arguments);
    }

    public static Object invokeMethod(Object object, String name, Class[] classes, Object[] arguments) {
        if (object == null) {
            throw new BodyBuilderException("object that '" + name + "' defined is null.");
        }
        return ObjectUtils.invokeMethod(object.getClass(), object, name, classes, arguments);
    }

    public static Object invokeMethod(Class clazz, Object object, String name, Class[] classes, Object[] arguments) {
        Method method = ObjectUtils.getMethod(clazz, name, classes);
        return ObjectUtils.invokeMethod(clazz, object, method, arguments);
    }

    public static Object invokeMethod(Class clazz, Object object, Method method, Object[] arguments) {
        try {
            method.setAccessible(true);
            return method.invoke(object, arguments);
        }
        catch (SecurityException e) {
            throw new BodyBuilderException("cannot invole method '" + method.getName() + "' as '" + object + "'.", e);
        }
        catch (IllegalArgumentException e) {
            throw new BodyBuilderException("cannot invole method '" + method.getName() + "' as '" + object + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new BodyBuilderException("cannot invole method '" + method.getName() + "' as '" + object + "'.", e);
        }
        catch (InvocationTargetException e) {
            throw new BodyBuilderException("cannot invole method '" + method.getName() + "' as '" + object + "'.", e);
        }
    }

    public static boolean isStaticMethod(Method method) {
        return method.toString().matches("^.* static .*$");
    }

    public static Object getFiledValue(String type, String name) {
        return ObjectUtils.getFiledValue(ObjectUtils.getClass(type), null, name);
    }

    public static Object getFiledValue(Object object, String name) {
        if (object == null) {
            throw new BodyBuilderException("object that '" + name + "' defined is null.");
        }
        return ObjectUtils.getFiledValue(object.getClass(), object, name);
    }

    public static Object getFiledValue(Class clazz, Object object, String name) {
        try {
            Field field = null;
            try {
                field = clazz.getField(name);
            }
            catch (NoSuchFieldException e) {
                field = clazz.getDeclaredField(name);
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (SecurityException e) {
            throw new BodyBuilderException("cannot get field '" + name + "' as '" + object + "(" + clazz + ")'.", e);
        }
        catch (NoSuchFieldException e) {
            throw new BodyBuilderException("cannot get field '" + name + "' as '" + object + "(" + clazz + ")'.", e);
        }
        catch (IllegalArgumentException e) {
            throw new BodyBuilderException("cannot get field '" + name + "' as '" + object + "(" + clazz + ")'.", e);
        }
        catch (IllegalAccessException e) {
            throw new BodyBuilderException("cannot get field '" + name + "' as '" + object + "(" + clazz + ")'.", e);
        }
    }

    public static boolean instance_of(Class clazz, String type) {
        List classes = ObjectUtils.getClassNames(clazz);
        return classes.contains(type);
    }

    public static boolean instance_of(Class clazz, Class type) {
        return ObjectUtils.instance_of(clazz, type.getName());
    }

    public static boolean instance_of(Object obj, String type) {
        List classes = ObjectUtils.getClassNames(obj);
        return classes.contains(type);
    }

    public static boolean instance_of(Object obj, Class type) {
        return ObjectUtils.instance_of(obj, type.getName());
    }

    public static String getPackage(String clazz, boolean asterisk) {
        int index = clazz.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        String pkg = clazz.substring(0, index);
        return asterisk ? pkg + ".*" : pkg;
    }

    public static String getPackage(String clazz) {
        return ObjectUtils.getPackage(clazz, false);
    }

    public static String getPackage(Class clazz) {
        return ObjectUtils.getPackage(clazz.getName());
    }

    public static String getPackage(Object obj) {
        if (obj == null) {
            return "";
        }
        return ObjectUtils.getPackage(obj.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

