/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Config {
    private static Properties config = new Properties();
    public static final String NL = System.getProperty("line.separator");
    protected static final String DEFAULT_CONFIG_FILE_NAME = "bodybuilder-default.properties";
    protected static final String CONFIG_FILE_NAME = "bodybuilder.properties";
    protected static final String PROP_KEY_PREFIX = "bodybuilder.";
    protected static final String INSPECTION_PROP_KEY_PRIFIX = "bodybuilder.inspection.";
    protected static final String VIEW_PROP_KEY_PRIFIX = "bodybuilder.view.";
    protected static final String BUILDER_PROP_KEY_PRIFIX = "bodybuilder.builder.";
    protected static final String VIEWER_PROP_KEY_PRIFIX = "bodybuilder.viewer.";
    protected static final String INSPECTOR_PROP_KEY_PRIFIX = "bodybuilder.inspector.";
    protected static final String VALUE_PROP_KEY_PRIFIX = "bodybuilder.value.";
    protected static final String TEST_PROP_KEY_PREFIX = "bodybuilder.test.";
    protected static final String DATABASE_PROP_KEY_PREFIX = "bodybuilder.database.";
    static /* synthetic */ Class class$bodybuilder$util$Config;

    public static boolean isValidate() {
        return Config.getBooleanProperty("bodybuilder.xml.validate", false);
    }

    public static String getOutputHandler() {
        return Config.getProperty("bodybuilder.output.handler");
    }

    public static boolean isInspectionSize() {
        return Config.getBooleanProperty("bodybuilder.inspection.size", true);
    }

    public static boolean isInspectionKeySetStrictly() {
        return Config.getBooleanProperty("bodybuilder.inspection.keyset.strictly", false);
    }

    public static boolean isInspectionClass() {
        return Config.getBooleanProperty("bodybuilder.inspection.class", true);
    }

    public static boolean isInspectionExceptionRegex() {
        return Config.getBooleanProperty("bodybuilder.inspection.exception.regex", true);
    }

    public static boolean isInspectionExceptionCause() {
        return Config.getBooleanProperty("bodybuilder.inspection.exception.cause", false);
    }

    public static Map getIgnoreProperties() {
        String[] cpvals = Config.getList(Config.getProperty("bodybuilder.inspection.ignore.properties"));
        HashMap<String, ArrayList<String>> ignores = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < cpvals.length; ++i) {
            String[] divided = cpvals[i].split("[|/]");
            ArrayList<String> props = new ArrayList<String>(Arrays.asList(divided));
            props.remove(0);
            ignores.put(divided[0], props);
        }
        return ignores;
    }

    public static boolean isViewPrintStackTrace() {
        return Config.getBooleanProperty("bodybuilder.view.stacktrace", false);
    }

    public static Map getBuilderMap() {
        return Config.subMap(BUILDER_PROP_KEY_PRIFIX);
    }

    public static Map getViewerMap() {
        return Config.newMap(VIEWER_PROP_KEY_PRIFIX, ".type", ".class");
    }

    public static Map getInspectorMap() {
        return Config.newMap(INSPECTOR_PROP_KEY_PRIFIX, ".type", ".class");
    }

    public static Map getValueMap() {
        return Config.newMap(VALUE_PROP_KEY_PRIFIX, ".format", ".class");
    }

    public static String[] getTestRootDirs() {
        String dirs = Config.getRequiredProperty("bodybuilder.test.root.dirs");
        String[] roots = Config.getList(dirs);
        for (int i = 0; i < roots.length; ++i) {
            roots[i] = FileUtils.removeEndSeparator(roots[i]);
        }
        return roots;
    }

    public static List getTestIgnoreDirs() {
        String dirs = Config.getProperty("bodybuilder.test.ignore.dirs");
        if (dirs == null) {
            return new ArrayList();
        }
        String[] ignores = Config.getList(dirs);
        for (int i = 0; i < ignores.length; ++i) {
            ignores[i] = FileUtils.removeEndSeparator(ignores[i]);
        }
        return Arrays.asList(ignores);
    }

    public static Map getTestCaseMap() {
        return Config.subMap("bodybuilder.test.type.");
    }

    public static String getDatabaseDriver() {
        return Config.getRequiredProperty("bodybuilder.database.driver");
    }

    public static String getDatabaseUrl() {
        return Config.getRequiredProperty("bodybuilder.database.url");
    }

    public static String getDatabaseUser() {
        return Config.getRequiredProperty("bodybuilder.database.user");
    }

    public static String getDatabasePassword() {
        return Config.getRequiredProperty("bodybuilder.database.password");
    }

    public static Map getDataSetMap() {
        return Config.subMap("bodybuilder.database.dataset.");
    }

    public static boolean isXlsTrim() {
        return Config.getBooleanProperty("bodybuilder.database.xlstrim", false);
    }

    public static String getProperty(String key) {
        String value = config.getProperty(key);
        return value != null ? value.trim() : value;
    }

    public static String getRequiredProperty(String key) {
        String value = Config.getProperty(key);
        if (value == null) {
            throw new BodyBuilderException("undefined property '" + key + "'.");
        }
        return value;
    }

    private static boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = Config.getProperty(key);
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        return defaultValue;
    }

    private static Map subMap(String prefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<Object> keys = config.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith(prefix)) continue;
            String value = Config.getProperty(key);
            key = key.substring(prefix.length());
            map.put(key, value);
        }
        return map;
    }

    private static Map newMap(String prefix, String keySuffix, String valSuffix) {
        String name;
        HashMap<String, String> map = new HashMap<String, String>();
        Map submap = Config.subMap(prefix);
        Iterator keys = submap.keySet().iterator();
        HashSet<String> nameSet = new HashSet<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            name = key.substring(0, key.indexOf(46));
            nameSet.add(name);
        }
        Iterator names = nameSet.iterator();
        while (names.hasNext()) {
            name = (String)names.next();
            String[] nameList = Config.getList((String)submap.get(name + keySuffix));
            String value = (String)submap.get(name + valSuffix);
            if (value == null) {
                throw new BodyBuilderException("undefined value corresponding to key '" + prefix + name + keySuffix + "'.");
            }
            for (int i = 0; i < nameList.length; ++i) {
                map.put(nameList[i], value);
            }
        }
        return map;
    }

    private static String[] getList(String str) {
        if (str == null) {
            return new String[0];
        }
        String[] strs = str.split(",");
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = strs[i].trim();
        }
        return strs;
    }

    private static void init() {
        config.clear();
        Config.load(DEFAULT_CONFIG_FILE_NAME, true);
        Config.load(CONFIG_FILE_NAME, false);
        config.putAll((Map<?, ?>)System.getProperties());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void load(String filename, boolean required) {
        InputStream in = null;
        try {
            try {
                ClassLoader cloader = Thread.currentThread().getContextClassLoader();
                if (cloader == null) {
                    cloader = (class$bodybuilder$util$Config == null ? (class$bodybuilder$util$Config = Config.class$("bodybuilder.util.Config")) : class$bodybuilder$util$Config).getClass().getClassLoader();
                }
                in = cloader.getResourceAsStream(filename);
                if (required && in == null) {
                    throw new BodyBuilderException("cannot load '" + filename + "' in CLASSPATH.");
                }
                if (in != null) {
                    config.load(in);
                }
            }
            catch (IOException e) {
                throw new BodyBuilderException("cannot load '" + filename + "'.", e);
            }
            Object var5_5 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new BodyBuilderException("cannot close '" + filename + "'.", e);
            }
        }
        try {}
        catch (IOException e) {
            throw new BodyBuilderException("cannot close '" + filename + "'.", e);
        }
        in.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Config.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new BodyBuilderException("failed to initialize '" + (class$bodybuilder$util$Config == null ? (class$bodybuilder$util$Config = Config.class$("bodybuilder.util.Config")) : class$bodybuilder$util$Config).getName() + "'.", e);
        }
    }
}

