/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test.jsp;

import bodybuilder.builder.servlet.RequestBuilder;
import bodybuilder.builder.servlet.ServletContextBuilder;
import bodybuilder.builder.servlet.SessionBuilder;
import bodybuilder.test.TestCaseXML;
import bodybuilder.util.FileUtils;
import bodybuilder.util.Utils;
import bodybuilder.util.jdom.JDOMUtils;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jdom.Element;

public class JSPTestCaseXML
extends TestCaseXML
implements Serializable {
    public static final int SETTER_INJECTION = 2;
    public static final int CONSTRUCTOR_INJECTION = 3;
    protected String path = null;
    protected String output = null;
    protected Element contextElem = null;
    protected Element requestElem = null;
    protected Element sessionElem = null;

    protected void build() {
        super.build();
        this.path = JDOMUtils.getRequiredChild(this.root, "path").getTextTrim();
        this.path = Utils.formatSlash(this.path);
        this.output = JDOMUtils.getRequiredChild(this.root, "output").getTextTrim();
        Element input = this.root.getChild("input");
        if (input != null) {
            this.loadInput(input);
        }
    }

    private void loadInput(Element input) {
        this.contextElem = input.getChild("servletcontext");
        this.requestElem = input.getChild("request");
        this.sessionElem = input.getChild("session");
    }

    public String getPath() {
        return this.path;
    }

    public String getOutput() {
        if (this.output == null) {
            return this.file.getAbsolutePath() + ".html";
        }
        if (!FileUtils.isFullPath(this.output)) {
            return this.file.getParent() + File.separator + this.output;
        }
        return this.output;
    }

    public Map getParama() {
        if (this.requestElem != null) {
            return RequestBuilder.getParams(this.requestElem);
        }
        return new HashMap();
    }

    public void setupServletContext(ServletContext context) {
        if (this.contextElem != null) {
            ServletContextBuilder.setup(this.contextElem, context);
        }
    }

    public void setupRequest(HttpServletRequest request) {
        if (this.requestElem != null) {
            RequestBuilder.setup(this.requestElem, request);
        }
    }

    public void setupSession(HttpSession session) {
        if (this.sessionElem != null) {
            SessionBuilder.setup(this.sessionElem, session);
        }
    }
}

