/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.inspector;

import bodybuilder.util.ObjectUtils;
import java.util.Stack;

public class ObjectBackTrace {
    private static final String NL = System.getProperty("line.separator");
    private static final String TAB = "  ";
    private StringBuffer buffer = new StringBuffer();
    private int level = 0;
    private Stack indentPoints = new Stack();
    private Stack indexPoints = new Stack();

    public void indent() {
        ++this.level;
        if (this.buffer.toString().endsWith(NL)) {
            int len = this.buffer.length();
            this.buffer.delete(len - NL.length(), len);
        }
        this.buffer.append(" {");
        this.setIndentPosition();
        this.buffer.append(NL);
        this.setIndexPosition();
    }

    public void unindent() {
        --this.level;
        this.rollbackIndentPosition();
        this.indexPoints.pop();
    }

    public void append(Object object) {
        this.nest();
        this.buffer.append(ObjectUtils.getInfo(object));
        this.buffer.append(NL);
    }

    public void appendIndex(int index) {
        this.rollbackIndexPosition();
        this.nest();
        this.buffer.append("[" + index + "]=>");
        this.buffer.append(NL);
    }

    public void appendKey(Object key) {
        this.appendKey(key, null);
    }

    public void appendKey(Object key, String suffix) {
        this.rollbackIndexPosition();
        this.nest();
        this.buffer.append("[\"" + key + "\"]");
        if (suffix != null) {
            this.buffer.append(suffix);
        }
        this.buffer.append("=>");
        this.buffer.append(NL);
    }

    String dump() {
        String trace = this.buffer.toString();
        this.clear();
        this.buffer = null;
        return trace;
    }

    void clear() {
        this.buffer.delete(0, this.buffer.length());
    }

    private void nest() {
        for (int i = 0; i < this.level; ++i) {
            this.buffer.append(TAB);
        }
    }

    private void setIndentPosition() {
        int pos = this.buffer.lastIndexOf(NL);
        if (pos >= 0) {
            this.indentPoints.push(new Integer(pos + NL.length()));
        }
    }

    private void rollbackIndentPosition() {
        if (this.indentPoints.size() < 1) {
            return;
        }
        Integer pos = (Integer)this.indentPoints.pop();
        if (pos != null) {
            this.buffer.delete(pos, this.buffer.length());
        }
    }

    private void setIndexPosition() {
        int pos = this.buffer.lastIndexOf(NL);
        if (pos >= 0) {
            this.indexPoints.push(new Integer(pos + NL.length()));
        }
    }

    private void rollbackIndexPosition() {
        Integer pos = (Integer)this.indexPoints.lastElement();
        if (pos != null && pos < this.buffer.length()) {
            this.buffer.delete(pos, this.buffer.length());
        }
    }
}

