/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.inspector;

import bodybuilder.inspector.InspectorMapping;
import bodybuilder.inspector.ObjectBackTrace;
import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;

public abstract class Inspector {
    private List targets = new ArrayList();

    public List getTargets() {
        return this.targets;
    }

    public void addTarget(String target) {
        this.targets.add(target);
    }

    public abstract void assertEquals(Object var1, Object var2, ObjectBackTrace var3);

    public static void assertObjectEquals(Object expected, Object actual) {
        ObjectBackTrace trace = new ObjectBackTrace();
        Inspector.assertObjectEquals(expected, actual, trace);
        trace.clear();
    }

    public static void assertObjectEquals(Object expected, Object actual, ObjectBackTrace trace) {
        trace.append(actual);
        Inspector.assertNullEquals(expected, actual, trace);
        if (expected == null && actual == null) {
            return;
        }
        Inspector inspector = InspectorMapping.getInspector(expected);
        if (inspector != null) {
            List actualClassNames = ObjectUtils.getClassNames(actual);
            List targets = inspector.getTargets();
            boolean isImplement = false;
            for (int i = 0; i < actualClassNames.size(); ++i) {
                String type = (String)actualClassNames.get(i);
                String pkg = ObjectUtils.getPackage(type, true);
                if (!targets.contains(type) && !targets.contains(pkg)) continue;
                isImplement = true;
                break;
            }
            if (!isImplement) {
                Inspector.rethrow("unimplement class", inspector.getTargets(), actual.getClass().getName(), trace);
            }
            trace.indent();
            inspector.assertEquals(expected, actual, trace);
            trace.unindent();
        } else {
            Inspector.assertClassEquals(expected, actual, trace);
            if (!expected.equals(actual)) {
                Inspector.rethrow(expected, actual, trace);
            }
        }
    }

    protected static void assertNullEquals(Object expected, Object actual, ObjectBackTrace trace) {
        if (expected != null && actual == null || expected == null && actual != null) {
            Inspector.rethrow(expected, actual, trace);
        }
    }

    protected static void assertClassEquals(Object expected, Object actual, ObjectBackTrace trace) {
        if (!Config.isInspectionClass()) {
            return;
        }
        Class<?> expectedClass = expected.getClass();
        Class<?> actualClass = actual.getClass();
        if (!expectedClass.getName().equals(actualClass.getName())) {
            Inspector.rethrow("classes differ", expectedClass, actualClass, trace);
        }
    }

    protected void assertSizeEquals(int expected, int actual, ObjectBackTrace trace) {
        this.assertSizeEquals("size differ", expected, actual, trace);
    }

    protected void assertSizeEquals(String message, int expected, int actual, ObjectBackTrace trace) {
        if (!Config.isInspectionSize()) {
            return;
        }
        if (expected != actual) {
            Inspector.rethrow(message, String.valueOf(expected), String.valueOf(actual), trace);
        }
    }

    protected void assertKeySetEquals(Set expected, Set actual, ObjectBackTrace trace) {
        this.assertKeySetEquals("key set differ", expected, actual, trace);
    }

    protected void assertKeySetEquals(String message, Set expected, Set actual, ObjectBackTrace trace) {
        Iterator expectedIte = expected.iterator();
        Iterator actualIte = actual.iterator();
        while (expectedIte.hasNext()) {
            Object expectedElement = expectedIte.next();
            if (actual.contains(expectedElement)) continue;
            Inspector.rethrow(message, expectedElement, null, trace);
        }
        if (Config.isInspectionKeySetStrictly()) {
            while (actualIte.hasNext()) {
                Object actualElement = actualIte.next();
                if (expected.contains(actualElement)) continue;
                Inspector.rethrow(message, null, actualElement, trace);
            }
        }
    }

    protected void assertRegexEquals(String regex, String actual, ObjectBackTrace trace) {
        this.assertRegexEquals("not macth regex", regex, actual, trace);
    }

    protected void assertRegexEquals(String message, String regex, String actual, ObjectBackTrace trace) {
        if (regex == null && actual == null) {
            return;
        }
        if (actual == null || regex == null) {
            Inspector.rethrow(message, regex, actual, trace);
        }
        if (!actual.matches(regex)) {
            Inspector.rethrow(message, regex, actual, trace);
        }
    }

    protected static void rethrow(Object expected, Object actual, ObjectBackTrace trace) {
        Inspector.rethrow(null, expected, actual, trace);
    }

    protected static void rethrow(String message, Object expected, Object actual, ObjectBackTrace trace) {
        StringBuffer buffer = new StringBuffer();
        if (message == null) {
            buffer.append("objects differ");
        } else {
            buffer.append(message);
        }
        buffer.append(" ");
        buffer.append("expected:<");
        buffer.append(expected);
        buffer.append("> but was:<");
        buffer.append(actual);
        buffer.append(">");
        buffer.append(System.getProperty("line.separator"));
        buffer.append(trace.dump());
        throw new AssertionFailedError(buffer.toString());
    }
}

