package bodybuilder.test.common;

import org.jdom.Element;

import bodybuilder.builder.Builder;

/**
 * catch
 */
public class Catch {

    /**
     * タイプ
     */
    private String type = null;

    /**
     * 例外
     */
    private Exception exception = null;

    /**
     * コンストラクタ
     * 
     * @param catchElem 例外要素
     */
    public Catch(Element catchElem) {
        // タイプを取得。
        type = catchElem.getAttributeValue("type");
        // 例外を取得。
        exception = (Exception) Builder.getValue(catchElem);

        // タイプがnullの場合は例外のクラス名をセット。
        if (type == null) {
            type = exception.getClass().getName();
        }
    }

    /**
     * タイプを取得する。
     * 
     * @return タイプ
     */
    public String getType() {
        return type;
    }

    /**
     * 例外を取得する。
     * 
     * @return 例外
     */
    public Exception getException() {
        return exception;
    }

}