package bodybuilder.inspector;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * マップインスペクター
 */
public class MapInspector extends Inspector {

    /**
     * 二つのマップが等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // マップを取得。
        Map expectedMap = (Map) expected;
        Map actualMap = (Map) actual;
        // キーセットを検査。
        Set expectedKeySet = expectedMap.keySet();
        assertKeySetEquals(expectedKeySet, actualMap.keySet(), trace);
        Iterator keys = expectedKeySet.iterator();

        // マップの値を検査。
        while (keys.hasNext()) {
            Object key = keys.next();
            trace.appendKey(key);
            Object expectedElement = expectedMap.get(key);
            Object actualElement = actualMap.get(key);
            assertObjectEquals(expectedElement, actualElement, trace);
        }
    }

}