package bodybuilder.exception;

import org.jdom.Element;

import bodybuilder.util.Config;
import bodybuilder.util.jdom.JDOMUtils;

/**
 * bodybuilderの例外
 */
public class BodyBuilderException extends RuntimeException {

    /**
     * 要素
     */
    private Element element = null;

    /**
     * 指定された詳細メッセージを使用して、新規例外を構築する。
     * 
     * @param message 詳細メッセージ
     */
    public BodyBuilderException(String message) {
        super(message);
    }

    /**
     * 指定された原因を使用して、新規例外を構築する。
     * 
     * @param cause 原因
     */
    public BodyBuilderException(Throwable cause) {
        super(cause);
    }

    /**
     * 指定された詳細メッセージおよび原因を使用して新規例外を構築する。
     * 
     * @param message 詳細メッセージ
     * @param cause 原因
     */
    public BodyBuilderException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * 指定された詳細メッセージを使用して、新規例外を構築する。
     * 
     * @param message 詳細メッセージ
     * @param element 要素
     */
    public BodyBuilderException(String message, Element element) {
        super(message);
        this.element = element;
    }

    /**
     * 指定された原因を使用して、新規例外を構築する。
     * 
     * @param cause 原因
     * @param element 要素
     */
    public BodyBuilderException(Throwable cause, Element element) {
        super(cause);
        this.element = element;
    }

    /**
     * 指定された詳細メッセージおよび原因を使用して新規例外を構築する。
     * 
     * @param message 詳細メッセージ
     * @param cause 原因
     * @param element 要素
     */
    public BodyBuilderException(String message, Throwable cause, Element element) {
        super(message, cause);
        this.element = element;
    }

    /**
     * 要素を取得する。
     * 
     * @return 要素
     */
    public Element getElement() {
        return element;
    }

    /**
     * 要素をセットする。<br>
     * 要素が既にセットされている場合は何も行わない。
     * 
     * @param element 要素
     */
    public void setElement(Element element) {
        if (this.element == null) {
            this.element = element;
        }
    }

    /**
     * メッセージを取得する。
     * 
     * @return メッセージ
     */
    public String getMessage() {
        if (element == null) {
            return super.getMessage();
        }

        StringBuffer buf = new StringBuffer(super.getMessage());
        buf.append(Config.NL);
        buf.append(JDOMUtils.toString(element));
        return buf.toString();
    }

}