package sample.testtarget.dicon.component;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbutils.QueryRunner;

import sample.testtarget.dicon.constant.Result;
import sample.testtarget.dicon.exception.BusinessException;
import sample.testtarget.dicon.object.Address;
import sample.testtarget.dicon.object.Return;
import sample.testtarget.dicon.object.Sysdate;
import sample.testtarget.dicon.object.impl.ReturnImpl;

/**
 * 住所録を更新する。
 * (Type2 - セッター・インジェクション)
 */
public class UpdateAddressBook_type2_throw_ex {

    private static QueryRunner qr = new QueryRunner();

    /////////////////////////////////////////////////////////////////
    // connection

    private Connection conn = null;

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    /////////////////////////////////////////////////////////////////
    // sysdate

    private Sysdate sysdate = null;

    public void setSysdate(Sysdate sysdate) {
        this.sysdate = sysdate;
    }

    /////////////////////////////////////////////////////////////////
    // logic

    public Return execute(Address address) throws SQLException {
        // 住所録を更新を更新。
        Object[] params = { address.getName(), address.getAge(),
                address.getSex().getValue(), address.getZipCode(),
                address.getAddress(), address.getTel(),
                sysdate.getNow().getTimestamp(), address.getId(),
                address.getUpdateDate().getTimestamp() };
        String update = "UPDATE ADDRESS_BOOK SET NAME=?, AGE=?, SEX=?, ZIP_CODE=?, ADDRESS=?, TEL=?, UPDATE_DATE=? WHERE ID=? AND UPDATE_DATE=?";
        int count = qr.update(conn, update, params);

        // 更新件数が0件の場合は例外を投げる。
        if (count < 1) {
            // 住所録の変更をロールバック。
            conn.rollback();

            // 業務例外を投げる。
            throw new BusinessException("ER0100");
        }

        // 住所録の変更をコミット。
        conn.commit();

        // 成功を返す。
        return new ReturnImpl(Result.SUCCESS, "更新に成功しました。");
    }

}