/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util.jdom;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;

public class JDOMUtils {
    private static final String TAB = "  ";

    public static Element getChild(Element element) {
        List children = element.getChildren();
        if (children == null || children.size() < 0) {
            return null;
        }
        if (children.size() > 1) {
            throw new BodyBuilderException("too many children as '" + element.getName() + "'.");
        }
        return (Element)children.get(0);
    }

    public static Element getRequiredChild(Element element) {
        List children = element.getChildren();
        if (children == null || children.size() < 0) {
            throw new BodyBuilderException("undefined child as '" + element.getName() + "'.");
        }
        return (Element)children.get(0);
    }

    public static Element getRequiredChild(Element element, String name) {
        Element child = element.getChild(name);
        if (child == null) {
            throw new BodyBuilderException("undefined element '" + name + "' as '" + element.getName() + "'.");
        }
        return child;
    }

    public static List getRequiredChildren(Element element, String name) {
        List children = element.getChildren(name);
        if (children == null || children.size() < 0) {
            throw new BodyBuilderException("undefined elements '" + name + "' as '" + element.getName() + "'.");
        }
        return children;
    }

    public static boolean hasChild(Element element, String name) {
        Element child = element.getChild(name);
        return child != null;
    }

    public static String getAttrValue(Element element, String name, String defaultValue) {
        String value = element.getAttributeValue(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String getRequiredAttrValue(Element element, String name) {
        String value = element.getAttributeValue(name);
        if (value == null) {
            throw new BodyBuilderException("undefined attribute '" + name + "' as '" + element.getName() + "'.");
        }
        return value;
    }

    public static boolean getAttrBoolValue(Element element, String name) {
        return JDOMUtils.getAttrBoolValue(element, name, true);
    }

    public static boolean getAttrBoolValue(Element element, String name, boolean defaultValue) {
        String value = element.getAttributeValue(name);
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        return defaultValue;
    }

    public static String toString(Element element) {
        ArrayList<String> elems = new ArrayList<String>();
        elems.add("<" + element.getName() + ">");
        while (!element.isRootElement()) {
            element = element.getParentElement();
            elems.add("<" + element.getName() + ">");
        }
        Collections.reverse(elems);
        StringBuffer buf = new StringBuffer();
        int size = elems.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < i; ++j) {
                buf.append(TAB);
            }
            buf.append(elems.get(i));
            if (i + 1 >= size) {
                buf.append(" <-");
            }
            buf.append(Config.NL);
        }
        return buf.toString();
    }
}

