package bodybuilder.viewer.handler;

import java.io.PrintWriter;

/**
 * 抽象出力ハンドラ
 */
public abstract class AbstractOutputHandler implements OutputHandler {

    /**
     * プリントライタ
     */
    private PrintWriter printWriter = null;

    /**
     * タブ
     */
    private String tab = null;

    /**
     * ネストレベル
     */
    private int level = 0;

    /**
     * コンストラクタ。
     * 
     * @param printWriter プリントライタ
     * @param tab タブ
     */
    protected AbstractOutputHandler(PrintWriter printWriter, String tab) {
        this.printWriter = printWriter;
        this.tab = tab;
    }

    /**
     * インデントする。
     */
    public void indent() {
        level++;
    }

    /**
     * アンインデントする。
     */
    public void unindent() {
        level--;
    }

    /**
     * 出力する。
     * 
     * @param str 文字列
     */
    public void print(String str) {
        printIndent();
        printWriter.println(str);
    }

    /**
     * インデントを出力する。
     */
    private void printIndent() {
        for (int i = 0; i < level; i++) {
            printWriter.print(tab);
        }
    }

}