package bodybuilder.test.database.excel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import jxl.BooleanCell;
import jxl.BooleanFormulaCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.DateFormulaCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.NumberFormulaCell;
import jxl.Sheet;
import jxl.StringFormulaCell;

import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;

class YetAnotherXlsTable extends AbstractTable {

    private final ITableMetaData _metaData;

    private final Sheet _sheet;

    public YetAnotherXlsTable(String sheetName, Sheet sheet)
            throws DataSetException {
        int rowCount = sheet.getRows();
        if (rowCount > 0) {
            _metaData = createMetaData(sheetName, sheet.getRow(0));
        } else {
            _metaData = new DefaultTableMetaData(sheetName, new Column[0]);
        }

        _sheet = sheet;
    }

    static ITableMetaData createMetaData(String tableName, Cell[] sampleRow) {
        List columnList = new ArrayList();

        for (int i = 0; i < sampleRow.length; i++) {
            Cell cell = sampleRow[i];
            Column column = new Column(cell.getContents(), DataType.UNKNOWN);
            columnList.add(column);
        }

        Column[] columns = (Column[]) columnList.toArray(new Column[0]);

        return new DefaultTableMetaData(tableName, columns);
    }

    ////////////////////////////////////////////////////////////////////////////
    // ITable interface

    public int getRowCount() {
        return _sheet.getRows() - 1;
    }

    public ITableMetaData getTableMetaData() {
        return _metaData;
    }

    public Object getValue(int row, String column) throws DataSetException {
        assertValidRowIndex(row);

        if (row + 1 >= _sheet.getRows()) {
            return null;
        }

        int columnIndex = getColumnIndex(column);
        Cell[] cells = _sheet.getRow(row + 1);

        if (columnIndex >= cells.length) {
            return null;
        }

        Cell cell = cells[columnIndex];
        CellType type = cell.getType();

        if (type == CellType.NUMBER) {
            NumberCell number = (NumberCell) cell;
            return new BigDecimal(number.getValue());
        } else if (type == CellType.NUMBER_FORMULA) {
            NumberFormulaCell numberFormula = (NumberFormulaCell) cell;
            return new BigDecimal(numberFormula.getValue());
        } else if (type == CellType.LABEL) {
            LabelCell label = (LabelCell) cell;
            return label.getString();
        } else if (type == CellType.STRING_FORMULA) {
            StringFormulaCell stringFormula = (StringFormulaCell) cell;
            return stringFormula.getString();
        } else if (type == CellType.EMPTY) {
            return null;
        } else if (type == CellType.BOOLEAN) {
            BooleanCell bool = (BooleanCell) cell;
            return bool.getValue() ? Boolean.TRUE : Boolean.FALSE;
        } else if (type == CellType.BOOLEAN_FORMULA) {
            BooleanFormulaCell booleanFormula = (BooleanFormulaCell) cell;
            return booleanFormula.getValue() ? Boolean.TRUE : Boolean.FALSE;
        } else if (type == CellType.DATE) {
            DateCell date = (DateCell) cell;
            return date.getDate();
        } else if (type == CellType.DATE_FORMULA) {
            DateFormulaCell dateFormula = (DateFormulaCell) cell;
            return dateFormula.getDate();
        } else if (type == CellType.ERROR) {
            throw new DataTypeException("Error at row=" + row + ", column="
                    + column);
        } else {
            throw new DataTypeException("Unsupported type at row=" + row
                    + ", column=" + column);
        }
    }

}