package bodybuilder.test;

import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.jdom.Element;

/**
 * テストスイートXML
 */
public class TestSuiteXML extends XML {

    /**
     * テストスイート
     */
    private TestSuite suite = new TestSuite();

    /**
     * テストスイートを取得。
     * 
     * @return テストスイート
     */
    public Test getTest() {
        return suite;
    }

    /**
     * テストスイートXMLを構築する。
     */
    protected void build() {
        // 子要素(テストケース)を取得。
        List children = root.getChildren();

        // 個々のテストケースをスイートに追加。
        for (int i = 0; i < children.size(); i++) {
            Element child = (Element) children.get(i);
            XML xml = XML.newXML(file, child);
            suite.addTest(xml.getTest());
        }
    }

}