package bodybuilder.builder.value;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;

/**
 * 拡張値マッピング
 */
class ExtendedValueMapping {

    /**
     * 拡張値のマップ
     */
    private static Map values = new HashMap();

    static {
        try {
            init();
        } catch (Throwable e) {
            e.printStackTrace();
            throw new BodyBuilderException("failed to initialize '"
                    + ExtendedValueMapping.class.getName() + "'.", e);
        }
    }

    /**
     * 初期化する。
     */
    private static void init() {
        // 正規表現とクラス名のマップを取得。
        Map valueMap = Config.getValueMap();
        // 正規表現のイテレータを取得。
        Iterator formats = valueMap.keySet().iterator();

        // 正規表現と拡張値オブジェクトのマップを作成。
        while (formats.hasNext()) {
            String format = (String) formats.next();
            String className = (String) valueMap.get(format);
            ExtendedValue value = (ExtendedValue) ObjectUtils
                    .getObject(className);
            values.put(format, value);
        }
    }

    /**
     * 拡張値にマッチした拡張値オブジェクトがあるかどうかを調べる。
     * 
     * @param value 拡張値
     * @return 拡張値オブジェクト
     */
    static boolean hasValue(String value) {
        // 正規表現のイテレータを取得。
        Iterator formats = values.keySet().iterator();

        // 拡張値が正規表現にマッチした場合、trueを返す。
        while (formats.hasNext()) {
            String format = (String) formats.next();

            if (value.matches("^" + format + "$")) {
                return true;
            }
        }

        // マッチする正規表現がなかったのでfalseを返す。
        return false;
    }

    /**
     * 拡張値にマップされた拡張値オブジェクトを取得する。
     * 
     * @param value 拡張値
     * @return 拡張値オブジェクト
     */
    static ExtendedValue getExtendedValue(String value) {
        ExtendedValue extVal = null;
        // 正規表現のイテレータを取得。
        Iterator formats = values.keySet().iterator();

        // 正規表現にマッチした拡張値オブジェクトを取得。
        while (formats.hasNext()) {
            String format = (String) formats.next();

            if (value.matches("^" + format + "$")) {
                extVal = (ExtendedValue) values.get(format);
            }

            if (extVal != null) {
                break;
            }
        }

        // 拡張値オブジェクトを返す。
        return extVal;
    }

}