package bodybuilder.builder.servlet;

import java.util.List;
import org.jdom.Element;

import com.mockrunner.mock.web.MockServletContext;

import bodybuilder.builder.Builder;
import bodybuilder.builder.argument.Argument;

/**
 * サーブレットコンテキストビルダー
 */
public class ServletContextBuilder extends Builder {

    /**
     * メソッド名
     */
    private static final String METHOD_ATTR = "attr";

    /**
     * サーブレットコンテキストを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return サーブレットコンテキスト
     */
    public Object getMuscle(Element element, Argument constructor) {
        // モックサーブレットコンテキストを生成。
        MockServletContext context = new MockServletContext();

        // <attr>を取得。
        List attrs = element.getChildren(METHOD_ATTR);

        // 属性をサーブレットコンテキストにセット。
        for (int i = 0; i < attrs.size(); i++) {
            Element child = (Element) attrs.get(i);
            String name = getRequiredName(child);
            Object value = getValue(child);
            context.setAttribute(name, value);
        }

        // サーブレットコンテキストを返す。
        return context;
    }

}