package bodybuilder.builder.argument;

import java.util.List;

import org.jdom.Element;

import bodybuilder.util.jdom.JDOMUtils;
import bodybuilder.builder.Builder;

/**
 * 引数ビルダー
 */
public class ArgumentBuilder extends Builder {

    {
        // コンストラクタは受け取らない。
        hasConstructor = false;
    }

    /**
     * 自身のインスタンス
     */
    private static final ArgumentBuilder instance = new ArgumentBuilder();

    /**
     * メソッド名
     */
    public static final String METHOD_NAME = "arg";

    /**
     * 引数を取得する。
     * 
     * @param element XML要素
     * @return 引数
     */
    public static Argument getArgument(Element element) {
        // シングルトンのインスタンスから引数を生成。
        return (Argument) instance.getMuscle(element, null);
    }

    /**
     * 引数を取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return 引数
     */
    public Object getMuscle(Element element, Argument constructor) {
        // 引数を生成。
        Argument argument = new Argument();
        // XML要素から<arg>を取得。
        List children = JDOMUtils.getRequiredChildren(element, METHOD_NAME);

        // <arg>からオブジェクトとクラスを取得し、引数に追加。
        for (int i = 0; i < children.size(); i++) {
            Element child = (Element) children.get(i);
            String type = getRequiredType(child);
            Object arg = getValue(child, type);
            argument.add(arg, type);
        }

        // 引数を返す。
        return argument;
    }

}