package bodybuilder.ant.xmltest;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

import bodybuilder.test.XMLTestRunner;
import bodybuilder.util.FileUtils;

/**
 * XMLテスト要素
 */
public class XMLJUnitTest extends JUnitTest {

    /**
     * コンストラクタ。
     */
    public XMLJUnitTest() {
        // XMLテストケースのクラス名をテスト名にセット。
        super(XMLTestRunner.class.getName());
    }

    /////////////////////////////////////////////////////////////////
    // name attribute

    /**
     * テスト名フラグ
     */
    private boolean named = false;

    /**
     * テスト名がセットされているかを取得する。
     * 
     * @return テスト名がセットされている場合はtrue
     */
    public boolean isNamed() {
        return named;
    }

    /**
     * テスト名をセットする。
     * 
     * @param value テスト名
     */
    public void setName(String value) {
        // フラグをtrueにする。
        named = true;
        // テスト名をセット。
        super.setName(value);
    }

    /////////////////////////////////////////////////////////////////
    // fork attribute

    /**
     * フォークフラグをセットする。
     * 
     * @param value フォークフラグ
     */
    public void setFork(boolean value) {
        // テストごとにフォークフラグをセットできないようにする。
        throw new BuildException(
                "The <xmltest> type doesn't support the \"fork\" attribute.");
    }

    /**
     * フォークフラグをセットする。
     * 
     * @param value フォークフラグ
     */
    void setFork2(boolean value) {
        super.setFork(value);
    }

    /////////////////////////////////////////////////////////////////
    // path attribute

    /**
     * パス
     */
    private String path = null;

    /**
     * パスをセットする。
     * 
     * @param path パス
     */
    public void setPath(String path) {
        // ドライブレターを削除してフィールドにセット。
        this.path = path = FileUtils.removeDriveLetter(path);
        // 出力ファイル名をセット。
        String outfile = "TEST-" + FileUtils.toDotSeparatedValue(path);
        setOutfile(outfile);
    }

    /**
     * パスを取得する。
     * 
     * @return パス
     */
    public String getPath() {
        return path;
    }

}