package sample.viewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpSession;
import com.mockrunner.mock.web.MockServletContext;

import bodybuilder.viewer.Viewer;

public class Sample04 {

    public static void main(String[] args) {
        {
            // モックサーブレットコンテキストを生成。
            ServletContext context = new MockServletContext();
            // サーブレットコンテキストに属性をセット。
            context.setAttribute("文字列", "じゅげむじゅげむ");
            context.setAttribute("数値", new Integer("100"));
            {
                List list = new ArrayList();
                context.setAttribute("リスト", list);
                list.add("値１");
                list.add("値２");
                list.add("値３");
            }
            // サーブレットコンテキストをダンプ。
            Viewer.dump(context);
            System.out.println();
        }

        {
            // モックリクエストを生成。
            HttpServletRequest request = new MockHttpServletRequest();
            // リクエストにパラメータをセット。
            ((MockHttpServletRequest) request).setupAddParameter("foo", "bar");
            ((MockHttpServletRequest) request).setupAddParameter("hoge",
                    new String[] { "hogera", "hogehoge" });
            // リクエストに属性をセット。
            request.setAttribute("文字列", "ごこうのすりきれ");
            request.setAttribute("数値", new Long("1000"));
            {
                Map map = new HashMap();
                request.setAttribute("マップ", map);
                map.put("キー１", "値１");
                map.put("キー２", "値２");
                map.put("キー３", "値３");
            }
            // リクエストをダンプ。
            Viewer.dump(request);
            System.out.println();
        }

        {
            // モックセッションを生成。
            HttpSession session = new MockHttpSession();
            // セッションに属性をセット。
            session.setAttribute("文字列", "ぱいぽぱいぽ");
            session.setAttribute("数値", new Short("10"));
            {
                String[] array = { "値１", "値２", "値３" };
                session.setAttribute("配列", array);
            }
            // セッションをダンプ。
            Viewer.dump(session);
        }
    }

}