package sample.builder;

import java.io.InputStream;

import bodybuilder.builder.Bullworker;
import bodybuilder.viewer.Viewer;

import sample.util.SampleUtils;

public class Sample02 {

    public static void main(String[] args) {
        InputStream in = SampleUtils
                .getResourceAsStream("sample/builder/data/sample02.xml");
        // ブルワーカを生成。
        Bullworker bullworker = new Bullworker(in);
        SampleUtils.closeInputStream(in);

        // setterで値をセットしたビーンを取得。
        Object obj_setter = bullworker.getMuscle("setter");
        // コンストラクタで値をセットしたビーンを取得。
        Object obj_constructor = bullworker.getMuscle("constructor");

        // オブジェクトをダンプ。
        Viewer.dump(obj_setter);
        Viewer.dump(obj_constructor);
    }

}