/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util;

import bodybuilder.exception.BodyBuilderException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class ExtendedPropertyUtils
extends PropertyUtils {
    public static Map getProperties(Object bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PropertyDescriptor[] props = PropertyUtils.getPropertyDescriptors((Object)bean);
        for (int i = 0; i < props.length; ++i) {
            String name;
            if (props[i].getReadMethod() == null || "class".equals(name = props[i].getName())) continue;
            Object value = ExtendedPropertyUtils.getProperty(bean, name);
            map.put(name, value);
        }
        return map;
    }

    public static Object getProperty(Object bean, String name) {
        try {
            return PropertyUtils.getProperty((Object)bean, (String)name);
        }
        catch (IllegalAccessException e) {
            throw new BodyBuilderException(e);
        }
        catch (InvocationTargetException e) {
            throw new BodyBuilderException(e);
        }
        catch (NoSuchMethodException e) {
            throw new BodyBuilderException(e);
        }
    }

    public static void setProperty(Object bean, String name, Object value) {
        try {
            PropertyUtils.setProperty((Object)bean, (String)name, (Object)value);
        }
        catch (IllegalAccessException e) {
            throw new BodyBuilderException(e);
        }
        catch (InvocationTargetException e) {
            throw new BodyBuilderException(e);
        }
        catch (NoSuchMethodException e) {
            throw new BodyBuilderException(e);
        }
    }

    public static void copyProperties(Object dest, Object orig) {
        try {
            PropertyUtils.copyProperties((Object)dest, (Object)orig);
        }
        catch (IllegalAccessException e) {
            throw new BodyBuilderException(e);
        }
        catch (InvocationTargetException e) {
            throw new BodyBuilderException(e);
        }
        catch (NoSuchMethodException e) {
            throw new BodyBuilderException(e);
        }
    }
}

