/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.type.builtin;

import java.math.BigInteger;

import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Enumeration;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;

/**
 * Represents ASN.1 'ENUMERATED' type.
 * 
 * <p>
 * This is the base class used for defining 'ENUMERATED' types. A sub-class of
 * {@code ENUMERATED} must contain one or more fields annotated as
 * {@code @ASN1Enumeration}.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 * 
 * @see ASN1Enumeration
 */
@ASN1BuiltIn
@ASN1Tag(tagClass = ASN1TagClass.UNIVERSAL, value = 10, tagMode = ASN1TagMode.IMPLICIT)
public abstract class ENUMERATED extends INTEGER {

	/**
	 * Instantiates an empty {@code ENUMERATED}.
	 */
	public ENUMERATED() {
	}

	/**
	 * Instantiates an {@code ENUMERATED} and initialize it with the
	 * {@code BigInteger} value.
	 * 
	 * @param value
	 *            The value to be assigned.
	 */
	public ENUMERATED(BigInteger value) {
		super(value);
	}

	/**
	 * Instantiates an {@code ENUMERATED} and initialize it with the {@code long}
	 * value.
	 * 
	 * @param value
	 *            The value to be assigned.
	 */
	public ENUMERATED(long value) {
		super(value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * jp.bitmeister.asn1.type.builtin.INTEGER#accept(jp.bitmeister.asn1.processor
	 * .ASN1Visitor)
	 */
	@Override
	public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
		return visitor.visit(this);
	}

}
