/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.sample;

import jp.bitmeister.asn1.annotation.ASN1Element;
import jp.bitmeister.asn1.annotation.ASN1ModuleRef;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.sample.FrightStatusTypes.FrightNumber;
import jp.bitmeister.asn1.sample.FrightStatusTypes.Information;
import jp.bitmeister.asn1.sample.FrightStatusTypes.Status;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.builtin.NULL;
import jp.bitmeister.asn1.type.builtin.SEQUENCE;

@ASN1ModuleRef(FrightStatusTypes.class)
@ASN1Tag(value = 0, tagClass = ASN1TagClass.APPLICATION, tagMode = ASN1TagMode.IMPLICIT)
public class FrightStatus extends SEQUENCE {

	@ASN1Element(0)
	public FrightNumber frightNo;
	
	@ASN1Element(1)
	@ASN1Tag(value = 0, tagMode = ASN1TagMode.IMPLICIT)
	public Information departure;
	
	@ASN1Element(2)
	@ASN1Tag(value = 1, tagMode = ASN1TagMode.IMPLICIT)
	public Information arrival;
	
	@ASN1Element(value = 3, hasDefault = true)
	@ASN1Tag(2)
	public Status status = new Status(ASN1TagClass.CONTEXT_SPECIFIC, 0, new NULL());
	
	public FrightStatus() {}

	public FrightStatus(FrightNumber frightNo, Information departure,
			Information arrival) {
		this.frightNo = frightNo;
		this.departure = departure;
		this.arrival = arrival;
	}

	public FrightStatus(FrightNumber frightNo, Information departure,
			Information arrival, Status status) {
		this.frightNo = frightNo;
		this.departure = departure;
		this.arrival = arrival;
		this.status = status;
	}
	
}
