/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.codec;

import jp.bitmeister.asn1.exception.ASN1DecodingException;
import jp.bitmeister.asn1.type.ASN1Type;

/**
 * The interface for ASN.1 decoder classes.
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
public interface ASN1Decoder {

	/**
	 * Decodes source data and sets these decoded values to an instance of the
	 * ASN.1 type.
	 * 
	 * @param <T>
	 *            Indicates the ASN.1 type.
	 * @param type
	 *            The class object of the ASN.1 type.
	 * @return An instance of the ASN.1 type.
	 * @throws ASN1DecodingException
	 *             Thrown when an error occurred while the decoding process.
	 */
	public <T extends ASN1Type> T decode(Class<T> type)
			throws ASN1DecodingException;

	/**
	 * Decodes source data to an ASN.1 data. The type of the data will be
	 * specified by type indicator (for example ASN.1 tag) included in the
	 * source data.
	 * 
	 * @return Decoded ASN.1 data.
	 * @throws ASN1DecodingException
	 *             Thrown when an error occurred while the decoding process.
	 */
	public ASN1Type decode() throws ASN1DecodingException;
	
}
