/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type.builtin;

import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.exception.ASN1IllegalArgument;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.PrimitiveType;
import jp.bitmeister.asn1.type.ValueComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ASN1BuiltIn
@ASN1Tag(tagClass=ASN1TagClass.UNIVERSAL, value=9, tagMode=ASN1TagMode.IMPLICIT)
public class REAL
extends PrimitiveType<Double>
implements ValueComparable {
    private boolean isBinary = false;

    public REAL() {
    }

    public REAL(boolean isBinary) {
        this.isBinary = isBinary;
    }

    public REAL(double value) {
        this.set(value);
    }

    public REAL(double value, boolean isBinary) {
        this(isBinary);
        this.set(value);
    }

    public REAL(long mantissa, int base, int exponent) {
        this.set(mantissa, base, exponent);
    }

    @Override
    public void set(Float value) {
        this.set(Double.valueOf(value.floatValue()));
    }

    public void set(long mantissa, int base, int exponent) {
        if (base == 2) {
            this.isBinary = true;
        } else if (base == 10) {
            this.isBinary = false;
        } else {
            ASN1IllegalArgument ex = new ASN1IllegalArgument();
            ex.setMessage("Invalid base value '" + base + "'. Base must be '2' or '10'.", null, this.getClass(), null, null);
            throw ex;
        }
        this.set((double)mantissa * Math.pow(base, exponent));
    }

    public void setBinaryEncoding() {
        this.isBinary = true;
    }

    public void setDecimalEncoding() {
        this.isBinary = false;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    @Override
    public int compareTo(ASN1Type other) {
        return ((Double)this.value()).compareTo((Double)((REAL)other).value());
    }

    @Override
    public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }
}

