/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.StringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimeType
extends StringType {
    @Override
    public void set(Date value) {
        this.set(this.form().format(value));
    }

    public Date date() {
        String time;
        String differential;
        String value = this.stringValue();
        if (value.endsWith("Z")) {
            differential = "+0000";
            time = value.substring(0, value.length() - 1);
        } else if (value.indexOf("+") < 0 && value.indexOf("-") < 0) {
            differential = String.format("%tz", Calendar.getInstance());
            time = value;
        } else {
            differential = value.substring(value.length() - 5, value.length());
            time = value.substring(0, value.length() - 5);
        }
        return this.parseDate(time, differential);
    }

    public abstract DateFormat form();

    @Override
    public Charset charset() {
        return Charset.forName("US-ASCII");
    }

    @Override
    public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    protected abstract Date parseDate(String var1, String var2);
}

