/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.util.ArrayList;
import java.util.List;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.type.NamedTypeSpecification;
import jp.bitmeister.asn1.type.StructuredType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ElementsChecker {
    Class<? extends StructuredType> type;
    private List<Integer> contextTags = new ArrayList<Integer>();
    private List<Integer> privateTags = new ArrayList<Integer>();

    ElementsChecker(Class<? extends StructuredType> type) {
        this.type = type;
    }

    void checkTagDuplication(NamedTypeSpecification element) {
        try {
            switch (element.tag().tagClass()) {
                case CONTEXT_SPECIFIC: {
                    if (this.contextTags.contains(element.tag().tagNumber())) {
                        throw new ASN1IllegalDefinition();
                    }
                    this.contextTags.add(element.tag().tagNumber());
                    break;
                }
                case PRIVATE: {
                    if (this.privateTags.contains(element.tag().tagNumber())) {
                        throw new ASN1IllegalDefinition();
                    }
                    this.privateTags.add(element.tag().tagNumber());
                }
            }
        }
        catch (ASN1IllegalDefinition ex) {
            ex.setMessage("Tag '" + (Object)((Object)element.tag().tagClass()) + " " + element.tag().tagNumber() + "' is duplicated.", null, this.type, element.identifier(), null);
            throw ex;
        }
    }
}

