/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.util.Collection;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.SizeCountable;
import jp.bitmeister.asn1.type.TypeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionType<T extends ASN1Type>
extends ASN1Type
implements SizeCountable {
    private Class<T> componentType;
    private Collection<T> collection;

    protected CollectionType(Class<T> componentType) {
        this.componentType = componentType;
        this.collection = this.newCollection();
    }

    protected CollectionType(Class<T> componentType, T ... components) {
        this(componentType);
        T[] TArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            T e = TArray[n2];
            this.collection.add(e);
            ++n2;
        }
    }

    public Collection<T> collection() {
        return this.collection;
    }

    public Class<T> componentType() {
        return this.componentType;
    }

    public TypeSpecification componentSpecification() {
        return TypeSpecification.getSpecification(this.componentType);
    }

    protected abstract Collection<T> newCollection();

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public void clear() {
        this.collection = this.newCollection();
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof CollectionType) {
            return this.collection.equals(((CollectionType)other).collection);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.collection.hashCode();
    }

    @Override
    public Object clone() {
        CollectionType clone = (CollectionType)ASN1Type.instantiate(this.getClass());
        clone.collection.addAll(this.collection);
        return clone;
    }
}

