/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.util.HashMap;
import java.util.Map;
import jp.bitmeister.asn1.type.ASN1Module;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagDefault;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.BuiltInModule;
import jp.bitmeister.asn1.type.ModuleSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASN1ModuleManager {
    private static ASN1ModuleManager instance = new ASN1ModuleManager();
    private Map<Class<? extends ASN1Module>, ModuleSpecification> definedModules = new HashMap<Class<? extends ASN1Module>, ModuleSpecification>();

    public static ASN1Type instantiate(Class<? extends ASN1Module> module, ASN1TagClass tagClass, int tagNumber) {
        if (tagClass == ASN1TagClass.UNIVERSAL) {
            return ASN1ModuleManager.specification(BuiltInModule.class).instantiate(tagClass, tagNumber);
        }
        if (module != null) {
            return ASN1ModuleManager.specification(module).instantiate(tagClass, tagNumber);
        }
        return null;
    }

    public static ASN1Type instantiate(Class<? extends ASN1Module> module, String typeIdentifier) {
        ASN1Type data = ASN1ModuleManager.specification(BuiltInModule.class).instantiate(typeIdentifier);
        if (data == null && module != null) {
            data = ASN1ModuleManager.specification(module).instantiate(typeIdentifier);
        }
        return data;
    }

    static ModuleSpecification specification(Class<? extends ASN1Module> module) {
        ModuleSpecification spec;
        if (module == null) {
            module = BuiltInModule.class;
        }
        if ((spec = ASN1ModuleManager.instance.definedModules.get(module)) == null) {
            spec = new ModuleSpecification(module);
            ASN1ModuleManager.instance.definedModules.put(module, spec);
        }
        return spec;
    }

    static ASN1TagDefault tagDefault(Class<? extends ASN1Module> module) {
        return ASN1ModuleManager.specification(module).tagDefault();
    }

    public static String identifier(Class<? extends ASN1Module> module) {
        return ASN1ModuleManager.specification(module).identifier();
    }

    private ASN1ModuleManager() {
    }
}

