/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.processor;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import jp.bitmeister.asn1.exception.ASN1RuntimeException;
import jp.bitmeister.asn1.processor.ASN1Processor;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.ASN1TagValue;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.CollectionType;
import jp.bitmeister.asn1.type.ConstructiveType;
import jp.bitmeister.asn1.type.ElementSpecification;
import jp.bitmeister.asn1.type.PrimitiveType;
import jp.bitmeister.asn1.type.StringType;
import jp.bitmeister.asn1.type.TimeType;
import jp.bitmeister.asn1.type.TypeSpecification;
import jp.bitmeister.asn1.type.UnknownType;
import jp.bitmeister.asn1.type.builtin.ANY;
import jp.bitmeister.asn1.type.builtin.BIT_STRING;
import jp.bitmeister.asn1.type.builtin.BOOLEAN;
import jp.bitmeister.asn1.type.builtin.CHOICE;
import jp.bitmeister.asn1.type.builtin.ENUMERATED;
import jp.bitmeister.asn1.type.builtin.INTEGER;
import jp.bitmeister.asn1.type.builtin.NULL;
import jp.bitmeister.asn1.type.builtin.OBJECT_IDENTIFIER;
import jp.bitmeister.asn1.type.builtin.OCTET_STRING;
import jp.bitmeister.asn1.type.builtin.REAL;
import jp.bitmeister.asn1.type.builtin.RELATIVE_OID;
import jp.bitmeister.asn1.type.builtin.SEQUENCE;
import jp.bitmeister.asn1.type.builtin.SEQUENCE_OF;
import jp.bitmeister.asn1.type.builtin.SET;
import jp.bitmeister.asn1.type.builtin.SET_OF;
import jp.bitmeister.asn1.value.BinString;
import jp.bitmeister.asn1.value.HexString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASN1StringBuilder
implements ASN1Processor<String, ASN1RuntimeException>,
ASN1Visitor<Void, ASN1RuntimeException> {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String SPACE = " ";
    private static final String INDENT = "\t";
    private static final String SEPARATOR = "\t";
    private static final String ASSIGN = " ::= ";
    private static final String CONSTRUCTIVE_OPEN = " {" + NEW_LINE;
    private static final String CONSTRUCTIVE_SEPARATOR = "," + NEW_LINE;
    private static final String CONSTRUCTIVE_CLOSE = " }";
    private static final String COLLECTION_OF = " OF ";
    private static final String IMPLICIT = " IMPLICIT";
    private static final String OPTIONAL = " OPTIONAL";
    private static final String VALUE_OPEN = "\t";
    private static final String VALUE_CLOSE = "";
    private static final String TAG_OPEN = "[";
    private static final String TAG_CLOSE = "]";
    private static final String NUMBER_OPEN = "(";
    private static final String NUMBER_CLOSE = ")";
    private static final String NULL = "null";
    private static final String NAMED_BITS_OPEN = "{";
    private static final String NAMED_BITS_CLOSE = "}";
    private static final String NAMED_BITS_SEPARATOR = ",";
    private static final String OID_OPEN = "{";
    private static final String OID_CLOSE = "}";
    private static final String STRING_OPEN = "\"";
    private static final String STRING_CLOSE = "\"";
    private static final String NOT_SET = "<No value>";
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss.S z]");
        }
    };
    private StringBuilder builder;
    private int indent;

    @Override
    public String process(ASN1Type data) {
        this.indent = 0;
        this.builder = new StringBuilder();
        this.write(data);
        return this.builder.toString();
    }

    private void write(ASN1Type data) {
        TypeSpecification specification = data.specification();
        while (true) {
            if (specification.hasIdentifier()) {
                this.builder.append(specification.identifier());
                if (specification.reference() == null) {
                    CollectionType collection;
                    if (!(data instanceof CollectionType) || (collection = (CollectionType)data).componentType().equals(ANY.class)) break;
                    this.builder.append(COLLECTION_OF).append(collection.componentSpecification().identifier());
                    break;
                }
                this.builder.append(ASSIGN);
                if (specification.tag() != null) {
                    this.writeTag(specification.tag());
                    this.builder.append(SPACE);
                }
            }
            specification = specification.reference();
        }
        if (data instanceof PrimitiveType) {
            this.builder.append("\t");
            if (data.hasValue()) {
                data.accept(this);
            } else {
                this.builder.append(NOT_SET);
            }
            this.builder.append(VALUE_CLOSE);
        } else {
            this.builder.append(CONSTRUCTIVE_OPEN);
            ++this.indent;
            data.accept(this);
            --this.indent;
            this.builder.append(CONSTRUCTIVE_CLOSE);
        }
    }

    @Override
    public Void visit(BOOLEAN data) {
        this.builder.append((Boolean)data.value() != false ? "TRUE" : "FALSE");
        return null;
    }

    @Override
    public Void visit(INTEGER data) {
        String numberId = data.identifier();
        if (numberId != null) {
            this.builder.append(numberId);
        }
        this.builder.append(NUMBER_OPEN).append(data.value()).append(NUMBER_CLOSE);
        return null;
    }

    @Override
    public Void visit(ENUMERATED data) {
        this.visit((INTEGER)data);
        return null;
    }

    @Override
    public Void visit(REAL data) {
        this.builder.append(NUMBER_OPEN).append(data.value()).append(NUMBER_CLOSE);
        return null;
    }

    @Override
    public Void visit(BIT_STRING data) {
        if (data.hasNamedBits()) {
            this.builder.append("{");
            boolean trailing = false;
            int i = 0;
            while (i < data.size()) {
                String identifier;
                if (data.bit(i) && (identifier = data.nameOfBit(i)) != null) {
                    if (trailing) {
                        this.builder.append(NAMED_BITS_SEPARATOR).append(SPACE);
                    } else {
                        this.builder.append(SPACE);
                        trailing = true;
                    }
                    this.builder.append(identifier);
                }
                ++i;
            }
            this.builder.append(SPACE).append("}").append("\t");
        }
        this.builder.append(new BinString((boolean[])data.value()).toString());
        return null;
    }

    @Override
    public Void visit(OCTET_STRING data) {
        this.builder.append(new HexString((byte[])data.value()).toString());
        return null;
    }

    @Override
    public Void visit(NULL data) {
        this.builder.append(NULL);
        return null;
    }

    @Override
    public Void visit(SEQUENCE data) {
        this.writeConstructive(data);
        return null;
    }

    @Override
    public Void visit(SEQUENCE_OF<? extends ASN1Type> data) {
        this.writeCollection(data);
        return null;
    }

    @Override
    public Void visit(SET data) {
        this.writeConstructive(data);
        return null;
    }

    @Override
    public Void visit(SET_OF<? extends ASN1Type> data) {
        this.writeCollection(data);
        return null;
    }

    @Override
    public Void visit(CHOICE data) {
        this.indent();
        if (!data.hasValue()) {
            this.builder.append(NOT_SET);
        } else {
            this.builder.append(data.selectedIdentifier());
            if (data.selectedTag() != null) {
                this.builder.append("\t");
                this.writeTag(data.selectedTag());
            }
            this.builder.append("\t");
            this.write(data.selectedValue());
        }
        return null;
    }

    @Override
    public Void visit(OBJECT_IDENTIFIER data) {
        this.builder.append("{");
        if (((List)data.value()).size() > 0) {
            this.builder.append(SPACE).append(((List)data.value()).get(0));
            int i = 1;
            while (i < ((List)data.value()).size()) {
                this.builder.append('.').append(((List)data.value()).get(i));
                ++i;
            }
            this.builder.append(SPACE);
        }
        this.builder.append("}");
        return null;
    }

    @Override
    public Void visit(RELATIVE_OID data) {
        return this.visit((OBJECT_IDENTIFIER)data);
    }

    @Override
    public Void visit(StringType data) {
        try {
            String value = data.stringValue();
            this.builder.append("\"").append(value).append("\"");
        }
        catch (Exception e) {
            this.builder.append(new HexString((byte[])data.value()).toString());
        }
        return null;
    }

    @Override
    public Void visit(TimeType data) {
        this.visit((StringType)data);
        this.builder.append(SPACE).append(DATE_FORMAT.get().format(data.date()));
        return null;
    }

    @Override
    public Void visit(ANY data) {
        this.write((ASN1Type)data.value());
        return null;
    }

    @Override
    public Void visit(UnknownType data) {
        int i = 0;
        while (i < data.value().length) {
            if (i % 16 == 0) {
                this.indent();
            }
            this.builder.append(String.format("%02X", data.value()[i]));
            this.builder.append(i % 16 == 15 ? NEW_LINE : SPACE);
            ++i;
        }
        return null;
    }

    private void writeConstructive(ConstructiveType data) {
        ElementSpecification[] elements = data.getElementTypeList();
        int i = 0;
        while (i < elements.length) {
            ASN1Type element;
            if (i != 0) {
                this.builder.append(CONSTRUCTIVE_SEPARATOR);
            }
            this.indent();
            this.builder.append(elements[i].identifier()).append("\t");
            if (elements[i].tag() != null) {
                this.writeTag(elements[i].tag());
                this.builder.append("\t");
            }
            if ((element = data.getComponent(elements[i])) == null) {
                this.builder.append(NOT_SET);
            } else {
                this.write(element);
            }
            if (elements[i].optional()) {
                this.builder.append(OPTIONAL);
            }
            ++i;
        }
    }

    private void writeCollection(CollectionType<? extends ASN1Type> data) {
        Iterator<? extends ASN1Type> itr = data.collection().iterator();
        if (itr.hasNext()) {
            while (true) {
                this.indent();
                this.write(itr.next());
                if (!itr.hasNext()) {
                    return;
                }
                this.builder.append(CONSTRUCTIVE_SEPARATOR);
            }
        }
        this.indent();
        this.builder.append(NOT_SET);
    }

    private void writeTag(ASN1TagValue tag) {
        this.builder.append(TAG_OPEN);
        if (tag.tagClass() != ASN1TagClass.CONTEXT_SPECIFIC) {
            this.builder.append((Object)tag.tagClass()).append(SPACE);
        }
        this.builder.append(tag.tagNumber()).append(TAG_CLOSE);
        if (tag.tagMode() == ASN1TagMode.IMPLICIT) {
            this.builder.append(IMPLICIT);
        }
    }

    private void indent() {
        int i = 0;
        while (i < this.indent) {
            this.builder.append("\t");
            ++i;
        }
    }
}

