/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.type;

import jp.bitmeister.asn1.annotation.ASN1Tag;

/**
 * Enumeration of ASN.1 tag classes.
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 * 
 * @see ASN1Tag
 */
public enum ASN1TagClass {

	/**
	 * Represents universal class.
	 */
	UNIVERSAL,

	/**
	 * Represents application class.
	 */
	APPLICATION,

	/**
	 * Represents context-specific class.
	 */
	CONTEXT_SPECIFIC {

		@Override
		public String toString() {
			return "CONTEXT-SPECIFIC";
		}

	},

	/**
	 * Represents private class.
	 */
	PRIVATE
}
