/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.type.ElementSpecification;
import jp.bitmeister.asn1.type.ElementsChecker;
import jp.bitmeister.asn1.type.StructuredType;

class OrderedElementsChecker
extends ElementsChecker {
    private ElementSpecification prevElement;

    OrderedElementsChecker(Class<? extends StructuredType> type) {
        super(type);
    }

    void check(ElementSpecification[] elements) {
        ElementSpecification[] elementSpecificationArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ElementSpecification e = elementSpecificationArray[n2];
            if (e.tag() == null) {
                if (this.prevElement != null && this.prevElement.tag() == null && this.prevElement.optional() && this.prevElement.isSameType(e)) {
                    ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                    ex.setMessage("Ambiguous element declaration. Check '" + this.prevElement.identifier() + "'.", null, this.type, e.identifier(), null);
                    throw ex;
                }
            } else {
                this.checkTagDuplication(e);
            }
            this.prevElement = e;
            ++n2;
        }
    }
}

