/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.bitmeister.asn1.annotation.ASN1Element;
import jp.bitmeister.asn1.exception.ASN1IllegalArgument;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.exception.ASN1InvalidDataValue;
import jp.bitmeister.asn1.type.ASN1TagDefault;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.ElementSpecification;
import jp.bitmeister.asn1.type.NamedTypeSpecification;
import jp.bitmeister.asn1.type.OrderedElementsChecker;
import jp.bitmeister.asn1.type.StructuredType;
import jp.bitmeister.asn1.type.TypeSpecification;
import jp.bitmeister.asn1.type.UnorderedElementsChecker;
import jp.bitmeister.asn1.type.builtin.SEQUENCE;
import jp.bitmeister.asn1.type.builtin.SET;

public abstract class ConstructiveType
extends StructuredType {
    private static Map<Class<? extends ConstructiveType>, ElementSpecification[]> ELEMENTS_MAP = new HashMap<Class<? extends ConstructiveType>, ElementSpecification[]>();

    private static ElementSpecification[] getElementTypeList(Class<? extends ConstructiveType> type) {
        NamedTypeSpecification[] array;
        if (ELEMENTS_MAP.containsKey(type)) {
            return ELEMENTS_MAP.get(type);
        }
        ArrayList<ElementSpecification> elements = new ArrayList<ElementSpecification>();
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.isAnnotationPresent(ASN1Element.class)) {
                elements.add(new ElementSpecification(f.getAnnotation(ASN1Element.class), f));
            }
            ++n2;
        }
        Class<? extends ConstructiveType> parent = type.getSuperclass();
        if (parent == SET.class || parent == SEQUENCE.class) {
            if (elements.isEmpty()) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("SET and SEQUENCE type shall have at least one element.", null, type, null, null);
                throw ex;
            }
            Collections.sort(elements);
            array = elements.toArray(new ElementSpecification[0]);
            if (TypeSpecification.getSpecification(type).tagDefault() == ASN1TagDefault.AUTOMATIC_TAGS) {
                ConstructiveType.generateAutomaticTags(array);
            }
            if (parent == SET.class) {
                new UnorderedElementsChecker(type).check(array);
            } else {
                new OrderedElementsChecker(type).check((ElementSpecification[])array);
            }
        } else {
            if (!elements.isEmpty()) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("If a class does not extend SET or SEQUENCE directly, it can not define own elements.", null, type, null, null);
                throw ex;
            }
            array = ConstructiveType.getElementTypeList(parent);
        }
        ELEMENTS_MAP.put(type, (ElementSpecification[])array);
        return array;
    }

    public ElementSpecification[] getElementTypeList() {
        return ConstructiveType.getElementTypeList(this.getClass());
    }

    public ASN1Type getComponent(ElementSpecification element) {
        return element.retrieve(this);
    }

    @Override
    public void set(NamedTypeSpecification component, ASN1Type data) {
        component.assign(this, data);
    }

    @Override
    public void set(String elementName, ASN1Type component) {
        this.set(this.getElement(elementName), component);
    }

    @Override
    public ASN1Type get(String elementName) {
        return this.getElement(elementName).retrieve(this);
    }

    @Override
    public NamedTypeSpecification getElement(String elementName) {
        ElementSpecification[] elementSpecificationArray = this.getElementTypeList();
        int n = elementSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementSpecification e = elementSpecificationArray[n2];
            if (e.identifier().equals(elementName)) {
                return e;
            }
            ++n2;
        }
        ASN1IllegalArgument ex = new ASN1IllegalArgument();
        ex.setMessage("No such element '" + elementName + "' in this type.", null, this.getClass(), null, null);
        throw ex;
    }

    @Override
    public void validate() {
        ElementSpecification[] elementSpecificationArray = this.getElementTypeList();
        int n = elementSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementSpecification e = elementSpecificationArray[n2];
            ASN1Type component = e.retrieve(this);
            if (component != null) {
                component.validate();
            } else if (!e.optional() && !e.hasDefault()) {
                ASN1InvalidDataValue ex = new ASN1InvalidDataValue();
                ex.setMessage("Mandatory data value is not present.", null, this.getClass(), e.identifier(), this);
                throw ex;
            }
            ++n2;
        }
    }

    @Override
    public void clear() {
        ElementSpecification[] elementSpecificationArray = this.getElementTypeList();
        int n = elementSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementSpecification e = elementSpecificationArray[n2];
            e.assign(this, null);
            ++n2;
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof ConstructiveType) {
            ConstructiveType comparison = (ConstructiveType)other;
            if (this.getElementTypeList() == comparison.getElementTypeList()) {
                ElementSpecification[] elementSpecificationArray = this.getElementTypeList();
                int n = elementSpecificationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ASN1Type compComponent;
                    ElementSpecification e = elementSpecificationArray[n2];
                    ASN1Type thisComponent = e.retrieve(this);
                    if (!(thisComponent == (compComponent = e.retrieve(comparison)) || thisComponent != null && compComponent != null && thisComponent.equals(compComponent))) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        ElementSpecification[] elementSpecificationArray = this.getElementTypeList();
        int n = elementSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementSpecification e = elementSpecificationArray[n2];
            ASN1Type element = e.retrieve(this);
            if (element != null) {
                hash += element.hashCode();
            }
            ++n2;
        }
        return hash;
    }

    @Override
    public Object clone() {
        ConstructiveType clone = (ConstructiveType)ASN1Type.instantiate(this.getClass());
        ElementSpecification[] elementSpecificationArray = this.getElementTypeList();
        int n = elementSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementSpecification e = elementSpecificationArray[n2];
            ASN1Type element = e.retrieve(this);
            if (element != null) {
                e.assign(clone, (ASN1Type)element.clone());
            }
            ++n2;
        }
        return clone;
    }
}

