/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.exception.ASN1InvalidDataValue;
import jp.bitmeister.asn1.exception.ASN1RuntimeException;
import jp.bitmeister.asn1.processor.ASN1Processor;
import jp.bitmeister.asn1.processor.ASN1StringBuilder;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.TypeSpecification;

public abstract class ASN1Type
implements Cloneable {
    public static ASN1Processor<String, ASN1RuntimeException> stringBuilder = new ASN1StringBuilder();

    public static <T extends ASN1Type> T instantiate(Class<T> type) {
        try {
            return (T)((ASN1Type)type.newInstance());
        }
        catch (InstantiationException e) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("Failed to instanciate the class.", e, type, null, null);
            throw ex;
        }
        catch (IllegalAccessException e) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("Default constructor might be not accessable.", e, type, null, null);
            throw ex;
        }
    }

    protected ASN1Type() {
    }

    public TypeSpecification specification() {
        return TypeSpecification.getSpecification(this.getClass());
    }

    public boolean matches(ASN1TagClass tagClass, int tagNumber) {
        return this.specification().matches(tagClass, tagNumber);
    }

    public void validate() throws ASN1InvalidDataValue {
        if (!this.hasValue()) {
            ASN1InvalidDataValue ex = new ASN1InvalidDataValue();
            ex.setMessage("This ASN.1 data has no value.", null, this.getClass(), null, this);
            throw ex;
        }
    }

    public abstract void clear();

    public abstract boolean hasValue();

    public abstract <R, E extends Throwable> R accept(ASN1Visitor<R, E> var1) throws E;

    public abstract boolean valueEquals(Object var1);

    public boolean equals(Object other) {
        if (other != null && this.getClass().equals(other.getClass())) {
            return this.valueEquals(other);
        }
        return false;
    }

    public abstract int hashCode();

    public abstract Object clone();

    public String toString() {
        if (stringBuilder == null) {
            return super.toString();
        }
        return stringBuilder.process(this);
    }
}

