// UTF-8 ☀☁☂☃
package irc;

// メッセージの出力先を表す定数
public class IRCLogContext{
	// 定数
	public static final IRCLogContext LB_All  = create("すべてのメッセージ");
	public static final IRCLogContext LB_Conn = create("接続バッファ");
	public static final IRCLogContext LB_Chan = create("チャンネルバッファ");
	public static final IRCLogContext LB_Priv = create("プリブバッファ");
	public static final IRCLogContext LB_Dump = create("ダンプバッファ");
	public static final IRCLogContext LF_Dump = create("ダンプログファイル",true);
	public static final IRCLogContext LF_Conn = create("接続ログファイル",true);
	public static final IRCLogContext LF_Chan = create("チャンネルログファイル",true);
	public static final IRCLogContext LF_Priv = create("プリブログファイル",true);

	// 識別子
	private String id; 
	public  String toString(){return id;}

	// 画面ではなくファイルに出力するか
	private boolean f_logfile; 
	public  boolean isLogFile(){return f_logfile;}

	// 作成
	private IRCLogContext(String s,boolean b){id=s;f_logfile=b;}
	private static IRCLogContext create(String s){return new IRCLogContext(s,false);}
	private static IRCLogContext create(String s,boolean b){return new IRCLogContext(s,b);}
}
