// UTF-8 ☀☁☂☃
package irc;
import java.io.*;
import java.util.*;
import java.net.*;
import java.text.*;
import base.*;

// 接続についての情報 永続的な情報を含む
public class IRCConnection implements Runnable{
	public static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("irc.ircconnection");
	static{ logger.setLevel(null); }


	public Object Extra; // 呼び出し側が好きに使って構わない

	public base.Logger base_logger;
	private IRCConnectionListener listener;
	public  IRCConnectionListener getListener(){ return listener;}

	public IRCConnection(IRCConnectionListener listener,base.Logger base_logger){
		if(listener==null) throw new NullPointerException("please specify IRCConnectionListener");
		if(base_logger==null) base_logger=new base.Logger(){
			public void Log(String s){ logger.info(s);}
		};
		this.listener = listener;
		this.base_logger=base_logger;
	}
	public void cleanup(){
		listener=null;
		Extra=null;
	}

	// 自動再接続の管理
	public boolean fAutoReconnect;
		// Connect を呼ぶとlistenrer.isAutoReconnect の値に設定されて、
		// 明示的に Disconnect を呼ぶとリセットされる
		// そうではないが切断された場合、fAutoReconnect なら再度Connectが呼ばれる

	// 自分の情報
	public String Nick;
	byte[] FirstPrefix;
	public byte[] NickLowerName;
	public byte[] getMyLowerNick(){return NickLowerName;}
	public IRCUser fromServer;
	public IRCUser myself;
	public String host001;

	/*
		接続が認証された直後に発行するコマンド。
		クリアするのは発行直後とConnDisconnect の時
	*/
	LinkedList command_on_authorized = new LinkedList();
	public void addCommandOnAuthorized(byte[] cmd){
		command_on_authorized.add(cmd);
	}



	//-----------------------------------
	// ログ出力
	void Log(String cmd,String s){ Log(cmd,null,s); }
	void Log(String cmd,IRCChannel chan,String s){
		if( listener == null ){
			String t = Util.GetTime(listener.getTimeZone(this));
			String c_name ="";
			if(chan!=null) c_name= chan.getShortName();
			logger.info( t+c_name+"@"+ listener.getConnectionName(this)+" "+cmd+" " + s );
			return;
		}
		IRCMessage m=new IRCMessage(this,cmd,s);
		m.addContext(chan).sendLogToListener();
	}

	//-----------------------------------
	// 接続

	IRCSocketReader sr;
	private boolean isConnect=false;
	public  boolean isConnected(){ return isConnect;}

	void SetNick(String s){ SendToServer(encodeString("NICK "+s),true,true); }

	public Socket getSocket(){
		return sr==null?null:sr.getSocket();
	}

	public void Connect(){ Connect(true);}

	int connect_try_count =0;
	public void Connect(boolean isFirst){
		if(isConnect) return;

		if(isFirst){
			connect_try_count=0;
			fAutoReconnect = listener.isAutoReconnect(this);
		}else{
			++connect_try_count;
			if(!fAutoReconnect) return;
		}

		isConnect = true;
		FirstPrefix =null;
		sr =null;
		myself=null;
		fromServer=null;
		host001=null;
		ctcp_send_cue=new LinkedList();
		try{
			String rhost = listener.getServerHost(this,connect_try_count);
			int rport = listener.getServerPort(this,connect_try_count);
			Log("OnConnectRequest",rhost +" "+rport+"に接続します…(試行"+(connect_try_count+1)+"回目)");

			sr = new IRCSocketReader(listener.getSelector()
				,rhost
				,rport
				,listener.getLocalHost (this)
				,listener.getLocalPort (this)
				,listener.getSoTimeout (this)
				,new IRCSocketReaderListener(){
					public void onConnect   (){ ConnConnect(); }
					public void onDisconnect(String s){ ConnDisconnect(s); }
					public void onRecvLine (byte[] ba){ ConnRecvLine( ba); }
					public void onConnectionError(Throwable e)
					{ Log("OnConnectionError",e.toString()+" "+e.getMessage()); }
					public void onMessageError(Throwable e){
						Log("OnMessageError",e.toString()+" "+e.getMessage());
						StackTraceElement[] list = e.getStackTrace();
						for(int i=0;i<list.length;++i){
							Log("OnMessageError","stack["+i+"]"
							+" "+list[i].getFileName()
							+" "+list[i].getLineNumber()
							+" "+list[i].getClassName()
							+" "+list[i].getMethodName() 
							+" native="+list[i].isNativeMethod() 
							);
						}
					}
				}
	 		);
		}catch(Throwable e){
			isConnect=false;
			Log("OnConnectionError",e.toString()+" "+e.getMessage());
			if(fAutoReconnect) listener.invokeLater(2<<connect_try_count,this);
		}
	}
	public void run(){
		Connect(false);
	}

	public void Disconnect(String s){
		if(!isConnect) return;
		Log("OnDisconnectRequest","切断します…("+s+")");
		fAutoReconnect = false;
		sr.WriteQuit(IRCChannelName.unescape("QUIT :"+s) ,s);
	}
	/////////////////////////////////////////////////////
	// IRCSocketReaderListener に呼ばれる
	public void ConnConnect(){
		if(myself!=null) return;
		try{
			String pass = getListener().getPassword(this);
			if(pass!=null && pass.length() >0 ){
				SendToServer(encodeString("PASS "+pass),false,true);
			}
			SetNick(getListener().getNickName(this,true));
			SendToServer(encodeString(
				"USER "+getListener().getUserName(this)
				+" 0 * :"+getListener().getRealName(this)
			),true,true);
			Log("OnConnect","接続しました。認証を待ちます…");
			if(listener!=null) listener.OnConnectRequest(this);
		}catch(Exception e){
			Log("OnError","接続に失敗しました"+e.toString()+" "+e.getMessage());
			logger.log(java.util.logging.Level.WARNING,"接続に失敗しました",e);
		}
	}

	// メッセージリーダから
	void ConnAuthorized(IRCMessage m){
		isConnect = true;
		getListener().OnConnectAuthorized(m);
		Log("OnConnectAuthorized","サーバに認証されました");
		for(Iterator it=command_on_authorized.iterator();it.hasNext();){
			sr.Write( (byte[])it.next() );
		}
		command_on_authorized.clear();
	}

	// IRCSocketReaderListener に呼ばれる
	void ConnDisconnect(String s){
		isConnect = false;
		ctcp_send_cue=null;
		command_on_authorized.clear();

		// 接続終了メッセージ
		IRCMessage m = new IRCMessage(this,"OnDisconnect","接続が終了しました "+s);
		m.addContext(this);
		for(Iterator it=_Channels.values().iterator();it.hasNext();){
			IRCChannel chan=(IRCChannel)it.next();
			boolean IsIn = chan.OnPartMyself();
			if(IsIn) listener.ChangeChannelJoin(this,chan,false);
			chan.RemoveUserAll(this);
			if(IsIn) m.addContext(chan);
		}
		m.sendLogToListener();
		listener.OnDisconnect(this);
		if(fAutoReconnect) listener.invokeLater(2,this);
	}


	// IRCSocketReaderListener に呼ばれる
	void ConnRecvLine(byte[] ba){
		if(ba==null || ba.length==0) return;
		try{
			Log("OnRecv",Util.fromJIS(ba));
			if(listener.isDumpRecvLine(this)) System.err.println(Util.GetTimeStr(listener.getTimeZone(this))+" s>"+Util.fromJIS(ba));
			// メッセージをパースする
			IRCMessage message = new IRCMessage(this,ba);
			message = listener.rewriteIRCMessage1(message);
			if(message==null) return;
			IRCMessageReader.checkMessage(message);
			// 出力コンテキストが決まったのでもう一度フック
			message = listener.rewriteIRCMessage2(message);
			if(message==null) return;
			message.sendLogToListener();
			// CTCPがないならこれで終わり
			IRCMessage[] ctcp=message.getCTCP();
			if(ctcp==null) return;
			// CTCPを処理する
			for(int i=0;i<ctcp.length;++i){
				// とりあえずログに記録
				if(listener.isDumpRecvCTCP(this)) System.err.println("OnRecvCTCP"
					+" from=" +(ctcp[i].log_from==null?"(null)":ctcp[i].log_from.getEscapedName())
					+" to="   +(ctcp[i].log_to==null?"(null)":ctcp[i].log_to.getEscapedName())
					+" ctcp=" +(ctcp[i].line==null?"(null)":Util.fromJIS( ctcp[i].line))
				);
				ctcp[i] = listener.rewriteIRCMessage1(ctcp[i]);
				if(ctcp[i]==null) return;
				IRCMessageReader.checkMessage(ctcp[i]);
				// 出力コンテキストが決まったのでもう一度フック
				ctcp[i] = listener.rewriteIRCMessage2(ctcp[i]);
				if(ctcp[i]==null) continue;
				ctcp[i].sendLogToListener();
			}
		}catch(Throwable e){
			logger.log(java.util.logging.Level.SEVERE,"ConnRecvLine: "+Util.GetTimeStr(listener.getTimeZone(this))+" s>"+Util.fromJIS(ba),e);
		}
	}

	//----------------------------------------------
	// IRCコマンドの送信
	public void SendToServer(byte[] ba,boolean recLog,boolean isFast){
		if(ba==null) return;
		if(recLog){
			// 補助メッセージ
			String tmp = Util.fromJIS(ba);
			Log("OnSend",tmp);
			if(listener.isDumpRecvLine(this)){ System.err.println("c>"+tmp); }
		}
		if(sr!= null ){
			if(isFast){
				 sr.WriteFast(ba);
			}else{
				 sr.Write(ba);
			}
		}
	}
	// 略記法
	public void SendToServer(byte[] ba){ SendToServer(ba,true,false); }


//	public void SendToServer(String s){ SendToServer(encodeString(s)); }

	// toJISしてIRCコマンドにする
	public static byte[] encodeString (String s)
	{ return Util.toJIS(s); }

	// ユーザが /join ∴#ほげ とか打った場合の文字列を
	// IRCChannelName.unescapeしてIRCコマンドにする
	public static byte[] encodeUserCommand(String s)
	{ return IRCChannelName.unescape(s); }

	// ユーザの普通の発言をIRCコマンドにする
	public byte[] encodeUserTalk(String a_cmd,byte[] to,byte[] text){
		try{
			ByteArrayOutputStream ba = new ByteArrayOutputStream();
			ba.write(Util.toJIS(a_cmd));
			ba.write((byte)' ');
			if(listener.isQuoteAllParam(this)){
				CTCPQuote.encodeParam(ba,to,0,to.length,false);
			}else{
				ba.write(to);
			}
			ba.write((byte)' ');
			ba.write((byte)':');
			CTCPQuote.encodeParam(ba,text,0,text.length,(!listener.isQuoteSpace(this)));
			return ba.toByteArray();
		}catch(IOException e){
			return null;
		}
	}

	// アプリケーション内部で組み立てた用
	public void SendToServer(List args)
	{ SendToServer(encodeList(args),true,false); }

	public byte[] encodeList(List args){
		ByteArrayOutputStream ba=new ByteArrayOutputStream();
		try{
			int i=0;
			for(Iterator it=args.iterator();it.hasNext();++i){
				Object o = it.next();
				byte[] b;
				// 区切りを書く
				if(i>0){
					ba.write(' ');
					if(i==args.size()-1) ba.write(':');
				}
				// 引数の種類を見る
				if(o instanceof byte[] ){
					b=(byte[])o;
				}else if(o instanceof String ){
					b=Util.toJIS((String)o);
				}else{
					 throw new Exception("SendToServer :unknown object type:"+o.toString());
				}
				// 設定によってはクォートして送る
				if(listener.isQuoteAllParam(this)){
					CTCPQuote.encodeParam(ba,b,0,b.length,(i==args.size()-1)&&(!listener.isQuoteSpace(this)));
				}else{
					ba.write(b);
				}
			}
		}catch(Exception e){
			Log("OnError","IRCConnection.SendToServer(List):"+e.getMessage());
			return null;
		}
		return ba.toByteArray();
	}

	// 単発のCTCPをIRCコマンドにする
	public byte[] encodeCTCP(byte[] to,List ctcp,String priv_or_notice){
		ByteArrayOutputStream ba = new ByteArrayOutputStream();
		byte[] cmd = Util.toJIS(priv_or_notice);
		CTCPQuote.encodeParam(ba,cmd,0,cmd.length,false);
		ba.write((byte)' ');
		CTCPQuote.encodeParam(ba,to,0,to.length,false);
		ba.write((byte)' ');
		ba.write((byte)':');
		ba.write((byte)1);
		Iterator it = ctcp.iterator();
		for(int i=0;it.hasNext();++i){
			Object o = it.next();
			byte[] b= ((o instanceof String)?Util.toJIS((String)o):(byte[])o);
			CTCPQuote.encodeParam(ba,b,0,b.length,(i==ctcp.size()-1)&&(!listener.isQuoteSpace(this)));
			if(i!= ctcp.size()-1){
				if(listener.isQuoteSpaceAtCTCPArg(this)){
					ba.write((byte)0x10);
					ba.write((byte) '@');
				}else{
					ba.write((byte)' ');
				}
			}
		}
		ba.write((byte)1);
		return ba.toByteArray();
	}

	//////////////////////////////////////////////////////////////////////////////
	// 過去に送ったCTCPのキュー
	// config_CtcpSendCueTimeExpire 秒に config_CtcpSendCueLimitInTime 個までしかCTCPに応答しない
	LinkedList ctcp_send_cue=null;
	public void SendCTCPReplyIfAvail(GregorianCalendar time,IRCUser to,List reply){
		if(ctcp_send_cue==null) return;
		long now = time.getTime().getTime();
		//キューから古いのを取り除く
		while( ctcp_send_cue.size() >0 ){
			if( ((Long)ctcp_send_cue.getFirst()).longValue()  >= now - listener.getCTCPSendCueTimeExpire(this) ) break;
			ctcp_send_cue.removeFirst();
		}
		// キューのサイズが大きいなら送らない
		if( ctcp_send_cue.size() > listener.getCTCPSendCueLimitInTime(this) ){
			base_logger.Log("flood対策のためにメッセージは送られなかった");
			return;
		}
		ctcp_send_cue.add( new Long(now));
		SendToServer(encodeCTCP(to.getRawBytes(),reply,"NOTICE"));
	}

	//----------------------------------------------
	// チャンネルのマップ

	private Map _Channels = new HashMap();
	public Object RemoveChannel(IRCChannel chan)
	{ return (IRCChannel) _Channels.remove(chan.getCName()); }

	public void ChangeChannelName(IRCChannelName oldName,IRCChannel chan){
			_Channels.remove(oldName);
			_Channels.put(chan.getCName(),chan);
	}
	public IRCChannel FindChannel(byte[] name,boolean CanCreate)
		{ return FindChannel(new IRCChannelName(name),CanCreate); }

	public IRCChannel FindChannel(String name,boolean CanCreate)
		{ return FindChannel(new IRCChannelName(name),CanCreate); }

	public IRCChannel FindChannel(IRCUser pref,boolean CanCreate)
	{ return FindChannel(new IRCChannelName(pref.getNick()),CanCreate); }

	public IRCChannel FindChannel(IRCChannelName key,boolean CanCreate){
		IRCChannel chan = (IRCChannel)_Channels.get(key);
		if(chan!=null || !CanCreate) return chan;
		chan =IRCChannel.createByIRCConnection(this,key);
		_Channels.put(key,chan);
		listener.initIRCChannel(this,chan);
		return chan;
	}

	public List getChannels(){
		Vector v = new Vector(_Channels.size());
		for(Iterator it=_Channels.values().iterator();it.hasNext();){
			v.add(it.next());
		}
		return v;
	}

	// 類似するチャンネル名の検索
	public IRCChannel findChannelAmbiguous(IRCChannelName name){
		// 長い名前もしくはエスケープされた名前が一致するか？
		for(Iterator it = _Channels.values().iterator();it.hasNext(); ){
			IRCChannel chan = (IRCChannel)it.next();
			if(chan.getCName().equals(name)) return chan;
		}
		// 短い名前が一致するか？
		for(Iterator it = _Channels.values().iterator();it.hasNext(); ){
			IRCChannel chan = (IRCChannel)it.next();
			if(chan.getCName().getShortName().equalsIgnoreCase( name.getShortName()) )
				return chan;
		}
		return null;
	}

	//------------------------------------------------------------
	// ユーザのマップ
	private IRCNicknameHash users=new IRCNicknameHash();

	public void removeUserAll()
	{ users.clear();}

	public IRCUser removeUser(IRCUser who)
	{ return (IRCUser)users.remove(who); }

	public IRCUser findUser(byte[] prefix){
		int i  = Util.ByteIndexOf(prefix,'!');
		IRCUser user = (IRCUser)users.get(i==-1?prefix:Util.ByteSubString(prefix,0,i));
		if(user==null){
			user = IRCUser.createByIRCConnection(prefix);
			users.put(user.getNickBytes(),user);
		}else if( i!=-1 ){
			i = user.updatePrefix( prefix,i );
			if(i!=0) listener.onChangePrefix(this,user,1);
		}
		return user;
	}

	public IRCUser changeUserNick(IRCUser from,byte[] newname){
		removeUser(from);
		from.changeNick(newname);
		users.put(from.getNickBytes(),from);
		return from;
	}
};

