// UTF-8 ☀☁☂☃
package irc;
import java.util.*;
import java.text.*;
import java.io.*;

public class IRCChannel implements IRCChannelNameOrPrefix{
	public Object Extra; // ユーザが好きに使用してよい

	//チャンネル名
	protected IRCChannelName name;
	public IRCChannelName getCName(){return name;}
	public void setCName(IRCChannelName c){name=c;}

	// implements IRCChannelNameOrPrefix
	public String getName			(){return name.getName();}
	public String getShortName		(){return name.getShortName();}
	public String getPrintableName	(){return name.getPrintableName();}
	public String getEscapedName	(){return name.getEscapedName();}
	public byte[] getLowerBytes		(){return name.getLowBytes();}
	public byte[] getRawBytes		(){return name.getRawBytes();}

	// ぷりぶ用のバッファの場合のみ有効
	protected IRCUser private_user;
	public boolean isChannel(){ return private_user==null;}
	public IRCUser getPrivateUser(){return private_user;}

	private String Topic="";
	public String getTopic(){ return Topic;}
	public void   setTopic(String s){ Topic=s;}

	private String mode="";
	public String getChannelMode(){ return mode;} 
	public void   setChannelModeString(String s){ mode=s; }

	protected boolean m_isInMyself =false;
	public boolean isInMyself(){return m_isInMyself;}

	//////////////////////////////////////
	// コンストラクタ

	private IRCChannel(IRCConnection conn,IRCChannelName a){
		 name=a;
		 if(! name.isChannelName()){
			private_user = conn.findUser( name.getRawBytes());
		}
	}

	public static IRCChannel createByIRCConnection(IRCConnection conn,IRCChannelName name)
	{ return new IRCChannel(conn,name); }

	//////////////////////////////////////////////
	// 自分の出入り
	// 既にその状態ならfalse ,状態を変更したらtrue
	public boolean OnJoinMyself(){
		if(m_isInMyself) return false;
		m_isInMyself = true;
		return true;
	}
	public boolean OnPartMyself(){
		if(!m_isInMyself) return false;
		m_isInMyself = false;
		return true;
	}

	//----------------------------------
	// チャンネル内のユーザの管理

	private IRCNicknameHash members = new IRCNicknameHash();
/*
	public void checkUL(bluntirc.ChannelMemberList l){
		for(Iterator it= members.
		
	}
*/
	public int getUserCount(){return members.size();}

	public IRCChannelMember findUser(IRCUser who)
	{ return (IRCChannelMember)members.get(who); }

	public IRCChannelMember findUser(byte[] key)
	{ return (IRCChannelMember)members.get(key); }

	public boolean isIn(IRCUser who)
	{ return findUser(who)!=null; }

	void AddUser(IRCMessage m,IRCUser who,String mode){
		IRCChannelMember member= (IRCChannelMember)members.get(who);
		byte[] old_name=null;
		if(member!=null){
			old_name = member.getUser().getNickBytes();
			members.remove(old_name);
		}
		member = new IRCChannelMember(who,mode);
		members.put( who ,member );
		m.conn.getListener().ChangeUserInfo(m.conn, this, old_name, member);
	}

	boolean RemoveUser(IRCMessage m,IRCUser who){
		IRCChannelMember member = (IRCChannelMember)members.get(who);
		if(member==null) return false;
		members.remove(who);
		m.conn.getListener().RemoveUserList(m.conn,this,member);
		return true;
	}
	void RemoveUserAll(IRCConnection conn){
		// スナップショットを取る
		Vector list= new Vector(members.size());
		for(Iterator it = members.values().iterator();it.hasNext();)
		{ list.add( it.next() ); }
		// その要素を全て消す
		for(Iterator it = list.iterator();it.hasNext();){
			IRCChannelMember member = (IRCChannelMember)it.next();
			members.remove(member.getUser());
			conn.getListener().RemoveUserList(conn,this,member);
		}
		// 保険
		members.clear();
	}

	boolean OnWhoReply(IRCMessage m,IRCUser key){
		if(isChannel() ) return null != findUser(key);
		return private_user == key;
	}

	boolean OnChangeNick(IRCMessage m,byte[] fromnick,IRCUser to,boolean isMyself){
		// チャンネルの場合
		if( isChannel() ){
			IRCChannelMember member = (IRCChannelMember)members.get(to);
			if(member==null) member = (IRCChannelMember)members.get(fromnick);
			if(member==null) return false;
			members.remove(to);
			members.remove(fromnick);
			member = new IRCChannelMember( to, member.OpString() );
			members.put(to,member);
			m.addContext(this);
			m.conn.getListener().ChangeUserInfo(m.conn,this,fromnick,member);
			return true;
		}else{
			// プライベート用のバッファの場合
			if(isMyself){
				// 自分のニックネーム変更は必ず出る
				m.addContext(this);
				m.conn.getListener().ChangeUserInfo(m.conn,this,fromnick,new IRCChannelMember(to,"") );
				return true;
			}else if( private_user == to ){
				// 相手の場合
				IRCChannelName old_cname = name;
				name = new IRCChannelName(private_user.getNickBytes());
				m.conn.ChangeChannelName(old_cname,this);
				m.addContext(this);
				m.conn.getListener().ChangeUserInfo(m.conn,this,fromnick,null);
				return true;
			}
		}
		return false;
	}

	//------------------------------------------
	// チャンネルモード、メンバ別に管理されるもの

	void addMemberMode(IRCMessage m,IRCUser who,char mode){
		IRCChannelMember member = findUser(who);
		if(member!=null && member.addOp(mode) )
		{ m.conn.getListener().ChangeUserInfo(m.conn, this, who.getNickBytes(), member); }
	}
	void removeMemberMode(IRCMessage m,IRCUser who,char mode){
		IRCChannelMember member = findUser(who);
		if(member!=null && member.removeOp(mode) )
		{ m.conn.getListener().ChangeUserInfo(m.conn, this, who.getNickBytes(), member); }
	}
	public boolean hasOp(IRCUser who)
	{ return hasOp(who,'@');}

	public boolean hasOp(IRCUser who,char type){
		IRCChannelMember member = findUser(who);
		return member!=null && member.hasOp(type);
	}

	//------------------------------------------
	// チャンネルモード

	void FixChannelMode(IRCMessage m,byte[] str){
		StringBuffer sb= new StringBuffer();
		for(int i=0;i<str.length;++i){
			int c= (str[i]&255);
			if(c>32 && c <127 ) sb.append((char)c);
		}
		mode = new String(sb);
		m.conn.getListener().SetChannelMode(m,this);
	}

	void SetChannelMode(IRCMessage m,char toggle,char c){
		if(toggle =='+'){
			// すでにあるモード文字か？
			if(-1 != mode.indexOf(c)) return;
			mode=mode+c;
			m.conn.getListener().SetChannelMode(m,this);
			return;
		}
		if(toggle =='-'){
			// すでにあるモード文字か？
			int pos = mode.indexOf(c);
			if(pos==-1) return;
			StringBuffer sb= new StringBuffer();
			for(int i=0;i<mode.length();++i){
				if(mode.charAt(i)!=c) sb.append(mode.charAt(i));
			}
			mode = new String(sb);
			m.conn.getListener().SetChannelMode(m,this);
		}
	}

	void SetChannelMode(IRCMessage m,char toggle,char c,IRCUser target){
		if(toggle == '+' && c == 'o' ){    addMemberMode(m,target,'@'); return; }
		if(toggle == '+' && c == 'v' ){    addMemberMode(m,target,'+'); return; }
		if(toggle == '-' && c == 'o' ){ removeMemberMode(m,target,'@'); return; }
		if(toggle == '-' && c == 'v' ){ removeMemberMode(m,target,'+'); return; }
		switch(c){
		case 'l':
		case 'k':
			SetChannelMode(m,toggle,c);
			return;
		}
		// 他は特に何もしない
		//if(-1!="beI".indexOf(c) ) return;
	}
};
