package gui;
import java.awt.*;

// 上書きの指定が可能なスタイル指定
public class FontInfo2{
	public FontInfo2(){style_mask=~0; }
	public FontInfo2(Color fg,Color bg,Color fg2,String name,int style,int size){
		color=new Color4();
		color.fg=fg;
		color.bg=bg;
		color.fg2=fg2;
		color.bg2=fg;
		style_mask=0;
		style_xor= style;
		font_name=name;
		font_size=size;
	}

	///////////////////////////////////////////
	// スタイル指定の拡張
	public static final int BOLD      =java.awt.Font.BOLD;   // ==1
	public static final int ITALIC    =java.awt.Font.ITALIC; // ==2
	public static final int UNDERLINE =4;
	public static final int REVERSE   =8;
	public static final int STRIKE    =16;
	
	// 有効なスタイル指定のマスク
	public static final int ALL_MASK= 0x1f; 
	// java.awt.Fontの作成に指定できる範囲のマスク
	public static final int BASIC_MASK=  3; 

	///////////////////////////////////////////
	// スタイル 初期値は inherit
	public int style_mask=~0;
	public int style_xor = 0;

	// 適用時はbit andしてxor する 00=>OFF 01=>ON 10=>inherit 11=>反転
	public int getStyleMask (){return style_mask;} 
	public int getStyleXOR  (){return style_xor ;}

	// オーバライドを考えないなら 直前が0だったとみなす
	public int getFontStyle(){ return style_xor ;}

	// 特定のビットのmask,xorを設定する
	public void setStyleBit(int value,int m_on,int x_on){
		if(m_on!=0) style_mask|=value; else style_mask&=~value;
		if(x_on!=0) style_xor |=value; else style_xor &=~value;
	}

	///////////////////////////////////////////
	public String font_name; // nullまたは長さ0ならinherit
	public int    font_size; // 0 ならinherit
	public int getFontSize(){ return font_size;}
	public String getFontName(){ return font_name;}

	// 下位の区間によるスタイル変更を許可するか
	public boolean allow_override=true;
	public boolean canOverride(){ return allow_override;}

	///////////////////////////////////////////
	// 色 文字色背景色、通常と選択中
	public Color4 color;

	///////////////////////////////////////////
	// キーを指定して値を読む
	public static final int KEY_FONTNAME =1; // null or フォント名
	public static final int KEY_BCA      =2; // null or BufferClickAdapter 
	public static final int KEY_COLOR4   =3;
	public static final int KEY_NOHOVER  =4;
	public static final int KEY_MENUSTRING  =5;
	public static final int KEY_MENULISTER  =6;
	public static final int KEY_NAME        =7;

	public static final int KEY_ASCENTPLUS  =8;
	public static final int KEY_DESCENTPLUS =9;
	public static final int KEY_LEADINGPLUS =10;

	public static final int KEY_CURSOR =11;


	public Object get(int key){
		switch(key){
		case KEY_FONTNAME :return font_name;
		case KEY_COLOR4 :return color;
		}
		// 継承して違う値を返すようにしてください
		return null;
	}

	//////////////////////
	// デフォルトのスタイル
	private static FontInfo2 defvalue;
	public static FontInfo2 getDefaultStyle(){return defvalue;}
	public static void setDefaultStyle(FontInfo2 s){defvalue=s;}
}
