// UTF-8 ☀☁☂☃
package dialog;
import bluntirc.*;
import irc.*;
import base.*;
import gui.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

abstract public class DialogBase
extends JDialog
implements KeyListener,ChangeListener,ActionListener,ItemListener 
{
	
	///////////////////////////
	JFrame parent;
	protected DialogBase(){ this(null); }
	protected DialogBase(JFrame parent)
	{ super(parent!=null?parent:App.main_window,false); }

	public JDialog getDialog(){return this;}
	protected void setup(ConnTreeNode node,DialogEditItem[] items){
		this.node=node;
		this.items=items;
		initGUI();
		CheckInputs();
	}
	// please override
	protected void CheckInputs_ok(){} 
	abstract protected ConnTreeNode createNode();
	public ConnTreeNode getNode(){ return node;}
	///////////////////////////

	protected DialogEditItem[] items;
	protected Component[] items_value;
	protected ConnTreeNode node;
	protected Action a_ok;

	protected Action[] buttons = new Action[]{
		new AbstractAction("OK"){
			public void actionPerformed(ActionEvent e){
				ApplyChanges();
				hide();
				dispose();
			}
		},
		new AbstractAction("キャンセル"){
			public void actionPerformed(ActionEvent e){
				hide();
				dispose();
			}
		},
	};

	public void stateChanged(ChangeEvent e){ CheckInputs(); }
	public void keyTyped(KeyEvent e){ /* typedだとコンポーネントの値の変更前にチェックしてしまう */}
	public void keyPressed(KeyEvent e){}
	public void keyReleased(KeyEvent e){CheckInputs();}
	public void actionPerformed(ActionEvent e){CheckInputs();}
	public void itemStateChanged(ItemEvent e){CheckInputs();}

	public void CheckInputs(){
		try{
			for(int i=0;i<items.length;++i) items[i].checkValue(items_value[i]);
		}catch(Exception e){
			setTitle( "入力エラー: "+e.getMessage() );
			a_ok.setEnabled(false);
			return;
		}
		a_ok.setEnabled(true);
		CheckInputs_ok();
	}
	public void ApplyChanges(){
		if(node==null) node= createNode();
		for(int i=0;i<items.length;++i) items[i].applyValue(node,items_value[i]);
	}
	protected void initGUI(){
		setResizable(false);
		StrictFocusTraversalPolicy ftp = new StrictFocusTraversalPolicy();
		JPanel RootPane = (JPanel) this.getContentPane();
		RootPane.setLayout(new BorderLayout());
		JTabbedPane tabbedPane = new JTabbedPane();
		tabbedPane.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT );
	//	tabbedPane.setTabPlacement(JTabbedPane.LEFT );
		RootPane.add(tabbedPane,BorderLayout.CENTER);
		tabbedPane.setFont(DialogEditItem.textFont);
		
		JPanel tfPanel=null;
		GridBagLayout gbl=null;
		GridBagConstraints c=null;

		items_value=new Component[items.length];
		String TabCaption=null;
		for(int i=0;i<items.length;++i){
			items_value[i] = items[i].createControl(node);
			if( items[i] instanceof DialogEditItem_TabSeparator ){
				if(tfPanel!=null){
					tabbedPane.addTab(TabCaption,tfPanel);
				}
				TabCaption =items[i].getCaption();
				tfPanel=new JPanel();
				tfPanel.setBorder(BorderFactory.createEmptyBorder(8,8,8,8));
				gbl = new GridBagLayout();
				tfPanel.setLayout(gbl);
				c = new GridBagConstraints();
				c.insets = new Insets(1,2,1,2) ;
				continue;
			}
			ftp.components.addLast(items_value[i]);
			items[i].layout(items_value[i],gbl,c,tfPanel,this);
		}
		if(tfPanel.getComponentCount() !=0 ){
			tabbedPane.addTab(TabCaption,tfPanel);
		}

		// ボタン
		JPanel btnPannel = new JPanel();
		for(int i=0;i<buttons.length;++i){
			if(buttons[i].getValue(Action.NAME).equals("OK") ){
				a_ok=buttons[i];
			}
			JButton b = new JButton(buttons[i]);
			b.setFont(DialogEditItem.textFont);
			btnPannel.add(b);
			ftp.components.addLast(b);
		}
		setFocusTraversalPolicy(ftp);
		RootPane.add(btnPannel,BorderLayout.SOUTH);
		pack();
		setLocationRelativeTo(parent);
		setVisible(true);
	}

}
