// UTF-8 ☀☁☂☃
/*
	ChannelMemberList はチャンネルメンバ一覧のデータを持ち、
	データに変更があった場合に ChannelMemberView にイベントを投げる。
*/

package bluntirc;
import java.util.*;
import javax.swing.event.TableModelEvent;
import irc.*;

class ChannelMemberList{
	private static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("bluntirc.channelmemberlist");
	static{ logger.setLevel(null); }

	ChannelMemberView view;
	public void removeView	(ChannelMemberView v){ view=null; }
	public void addView	(ChannelMemberView v){ view=v;}

	//////////////////////////////////////////////////////
	// リスト
	public static Comparator nickname_comparator = IRCUser.createComparator();
	LinkedList members_ary =new LinkedList();
	public int getRowCount(){ return members_ary.size(); }
	public IRCChannelMember getByRow(int row){ return (IRCChannelMember)members_ary.get(row);}

	// ニックネームで検索してインデクスを返す
	public int findNick(byte[] key){
		int i=0;
		for(Iterator it=members_ary.iterator();it.hasNext();++i){
			IRCChannelMember m=(IRCChannelMember)it.next();
			if(nickname_comparator.compare(m,key)==0) return i;
		}
		return -1;
	}

	//////////////////////////////////////////////////////
	// 比較器
	Comparator comparator=nickname_comparator;

	// IRCChannelMemberを見て挿入する位置を返す
	public int findInsertPoint(IRCChannelMember key){
		int i=0;
		for(Iterator it=members_ary.iterator();it.hasNext();++i){
			IRCChannelMember m=(IRCChannelMember)it.next();
			if(comparator.compare(m,key)>=0) return i;
		}
		return i;
	}

	// ソート
	public void sort(Comparator new_comparator){
		if(new_comparator!=null) comparator= new_comparator;
		Collections.sort(members_ary,comparator);
		if(view!=null){view.fireTableModelListener(new TableModelEvent(view));}
	}


	//////////////////////////////////////////////////////
	// ユーザリストの変化に合わせて呼ばれて、
	// リストを変更してview にイベントを通知する

	public void setWhoReply(IRCUser who){
		int i=findNick( who.getNickBytes() );
		if(i!=-1 && view!=null) view.fireTableModelListener(new TableModelEvent(view, i, i, TableModelEvent.ALL_COLUMNS, TableModelEvent.UPDATE));
	}

	public void RemoveUserList(IRCChannelMember who){
		int i= findNick(who.getUser().getNickBytes());
		if(i==-1) return;
		members_ary.remove(i);
		if(view!=null){view.fireTableModelListener(new TableModelEvent(view, i, i, TableModelEvent.ALL_COLUMNS, TableModelEvent.DELETE));}
	}

	public void AddUserList( IRCChannelMember who )
	{ ChangeUserInfo(null,who); }

	public void ChangeUserInfo(byte[] from_nick,IRCChannelMember to){
		int i;

		// IRCChannelMemberの中でのニックネーム変更がすでに行われていた場合、
		// to ニックで検索したものが古い位置にある
		i=findNick(to.getUser().getNickBytes());

		// toにない場合、from_nickを見る。
		// たぶんここは通らないと思うが…？
		if(i==-1 && from_nick!=null){
			logger.warning(
				"ChangeUserInfo "
				+(from_nick==null?"(null)":base.Util.fromJIS(from_nick))
				+"=>"+to.getUser().getName()
			);
			i = findNick(from_nick);
		}
		// リスト中での位置が変わることがあるので、古い項目を一度リストから取り除く。
		if(i!=-1){
			members_ary.remove(i);
			if(view!=null) view.fireTableModelListener(new TableModelEvent(view, i, i, TableModelEvent.ALL_COLUMNS, TableModelEvent.DELETE));
		}
		// 追加する
		i = findInsertPoint( to );
		members_ary.add(i,to);
		if(view!=null) view.fireTableModelListener(new TableModelEvent(view, i, i, TableModelEvent.ALL_COLUMNS, TableModelEvent.INSERT));
	}
};
