package bluntirc;
import irc.*;
import base.*;
import java.util.*;
import javax.swing.ImageIcon;

public class CTN_Chan extends ConnTreeNode{
	/////////////////////////////////////////////////////////////////

	public IRCChannel chan;
	public CTN_Chan getChannelNode(){return this;}
	public CTN_Conn getConnNode(){return (CTN_Conn)getParent();}
	public IRCChannel GetChannel(){ return chan;}
	public IRCChannel getChannel(){ return chan;}
	public String GetCaption(){ return chan.getShortName(); }

	/////////////////////////////////////////////////////////////////

	public ChannelMemberList userlist=new ChannelMemberList();
	public ChannelMemberList getUserList(){ return userlist;}

	/////////////////////////////////////////////////////////////////

	static ImageIcon icon_chan  = Util.GetImageIconFromJAR("images/chan1.gif");
	static ImageIcon icon_chanM = Util.GetImageIconFromJAR("images/chan2.gif");
	static ImageIcon icon_chanD = Util.GetImageIconFromJAR("images/chan3.gif");
	public ImageIcon getImageIcon()
	{ return (!chan.isInMyself()) ? icon_chanD :hasMidoku ?icon_chanM :icon_chan; }

	/////////////////////////////////////////////////////////////////

	boolean hasMidoku = false;
	public void addMidoku(buffer.PackedLineWriter line,boolean noMidokuCheck){
		super.addMidoku(line,null);
		if( !hasMidoku &&  !noMidokuCheck&&  App.getSelected() != this ){
			hasMidoku=true;
			App.redrawTreeView(this);
		}
	}
	public void OnSelect(){ hasMidoku=false; App.selectTreeView(this); }

	/////////////////////////////////////////////////////////////////

	public String getPopupName(){ return "popup-channel";}
	public int getListLevel(){ return 2;}

	public String getTitle()
	{ return getConnNode().GetCaption()+" "+GetCaption()+" "+chan.getChannelMode()+" "+chan.getTopic();}
	public String getBufferInfo()
	{
		int minc = chan.getUserCount();
		int minv = userlist.getRowCount();
		if(minc!=minv){
			 App.Log("内部でのユーザの管理がおかしいです IRCChannel="+minc+" UserTableList="+minv);
			Thread. dumpStack();
		//	 chan.checkUL(userlist.members_ary);
		}
		return super.getBufferInfo()+" "+Integer.toString(chan.getUserCount())+"人";
	}

	public void checkAutoJoin()
	{ if(property.getBoolean("AutoJoin",false)) OnMenuJoin(); }

	public void OnDoubleClick(java.awt.event.MouseEvent e)
	{
		IRCConnection conn = getConnNode().conn;
		if( conn.isConnected() ){
			OnMenuJoin(); 
			return;
		}
		
		getConnNode().OnDoubleClick(e);
		// 今コマンドを出しても登録前ってことでハネられるな…
		Vector v= new Vector();
		v.add("JOIN");
		v.add(chan.getCName().getJoinNameBytes());
		String pass = property.getString("Password");
		if(pass != null && pass.length() >0 )v.add(pass);
		conn.addCommandOnAuthorized(conn.encodeList(v));
	}

	///////////////////////////////////////////////////////////
	// プロパティの管理

	public void setDefaultOption(){
		property.setDefaultString ("Password"		 ,"");
		property.setDefaultBoolean("AutoJoin"		 ,false);
		property.setDefaultBoolean("RejoinOnKicked"	 ,false);
		property.setDefaultBoolean("AutoWho"		 ,false);
		property.setDefaultBoolean("AutoModeQuery"	 ,true);
	}
	public Object getPropertyExtra(){ return chan;}
	public void onHashSave(){}
	public void onHashLoad(){}
	public void onPropertyChanged(String name,Object value){}

	////////////////////////////////////////////
	// よく使うコマンド

	public void OnMenuJoin(){
		Vector v= new Vector();
		v.add("JOIN");
		v.add(chan.getCName().getJoinNameBytes());
		String pass = property.getString("Password");
		if(pass != null && pass.length() >0 )v.add(pass);
		getConnNode().conn.SendToServer(v);
	}
	public void OnMenuPart(String msg){
		Vector v=new Vector();
		v.add("PART");
		v.add(chan.getCName().getRawBytes());
		v.add(Util.toJIS(msg));
		getConnNode().conn.SendToServer(v);
	}
	public void OnMenuTopic(String msg){
		Vector v=new Vector();
		v.add("TOPIC");
		v.add(chan.getCName().getRawBytes());
		v.add(Util.toJIS(msg));
		getConnNode().conn.SendToServer(v);
	}
	public void addOp(IRCChannelMember u,String op){
		Vector v=new Vector();
		v.add("MODE");
		v.add(chan.getCName().getRawBytes());
		v.add(op);
		v.add(u.getUser().getNickBytes());
		getConnNode().conn.SendToServer(v);
	}

	/////////////////////////////////////////////////////////////////
	// 作成と破棄

	public static ConnTreeNode createNode(ConnTreeNode parent,java.util.List param){
		String name =(String)param.get(0);
		IRCChannel chan=((CTN_Conn)parent).conn.FindChannel(IRCChannelName.unescape(name),true);
		return (ConnTreeNode)chan.Extra;
	}

	public static ConnTreeNode createByInitIRCChannel(ConnTreeNode p,IRCChannel chan){ return new CTN_Chan(p,chan); }

	private CTN_Chan(ConnTreeNode p,IRCChannel chan){
		super(null);
		this.chan=chan;
		CTN_Conn parent=(CTN_Conn)p;
		chan.Extra = this;
		parent.insertNodeInto(this);
		setDefaultOption();
	}

	public java.util.List getCreateParam(){
		LinkedList l=new LinkedList();
		l.add( GetChannel().getEscapedName() );
		return l;
	}

	public void PreRemove(){
		// IRCConnectionからチャンネルを取り除く
		CTN_Conn conn_node = getConnNode();
		if(conn_node==null) return;
		IRCConnection conn = conn_node.conn;
		if(conn==null) return;
		conn.RemoveChannel(chan);
	}
}
