package bluntirc;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import gui.*;
import java.awt.datatransfer.*;
import java.awt.dnd.*;


// バッファ一覧を表示するSwingコンポーネント
public class BufferList
extends JComponent
implements Scrollable,Transferable
{
	private static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("bluntirc.bufferlist");
	static{ logger.setLevel(null); }

	////////////////////////
	// Scrollable 
	protected int line_height = 16;
	public boolean getScrollableTracksViewportWidth(){ return false;}
	public boolean getScrollableTracksViewportHeight(){ return false; }
	public Dimension getPreferredScrollableViewportSize(){ return getPreferredSize(); }
	public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction){
		return (
			(orientation==SwingConstants.HORIZONTAL)
			?visibleRect.width
			:visibleRect.height
		)-line_height;
	}
	public int getScrollableUnitIncrement(Rectangle visibleRect,int orientation,int direction ){
		return line_height;
	}

	//////////////////////////////////////////
	// implements java.awt.datatransfer.Transferable
	
	public DataFlavor[] getTransferDataFlavors(){ return my_DataFlavor; }
	static DataFlavor[] my_DataFlavor = new DataFlavor[]
	{ 
		new DataFlavor(BufferList.class,"バッファ項目"),
		DataFlavor.getTextPlainUnicodeFlavor(),
	};

	public boolean isDataFlavorSupported(DataFlavor flavor){
		for(int i=0;i<my_DataFlavor.length;++i)
			if(my_DataFlavor[i].equals(flavor)) return true;
		return false;
	}
	public Object getTransferData(DataFlavor flavor)
	throws UnsupportedFlavorException,java.io.IOException{
		if(my_DataFlavor[0].equals(flavor))
			return new Integer(getSelectedIndex());
		return getSelected().getListLabel1();
	}
	public boolean canDrop(DataFlavor flavor){
		return my_DataFlavor[0].equals(flavor);
	}
	public void exportDone(){
		drug_from = -1;
		repaint(300);
	}
	void check_drop(DropTargetDragEvent e){
		System.out.println("check_drop");

		boolean flag=false;
		if(e!=null){
			DataFlavor[] list = e.getCurrentDataFlavors();
			for(int i=0;i<list.length;++i){
				if(canDrop(list[i])){
					flag=true;break;
				}
			}
		}
		if(e==null || !flag){
			drug_to=-1;
			repaint(300);
			return;
		}
		Point  p= getLocation();
		drug_to = pointItemAt(p,true);
		repaint(300);
	}

	////////////////////////
	// 項目のリストと選択状態
	public LinkedList list = new LinkedList();
	protected int selected =-1; // 選択中の項目

	public int getCount(){ return list.size();}
	public ConnTreeNode getItem(int index){
		if(index <0 || index >=list.size())return null;
		return (ConnTreeNode)list.get(index);
	}
	public void addItem(ConnTreeNode item){
		if(item==null) throw new NullPointerException();
		list.addLast(item);notifySizeChange();
	}
	public void addItem(ConnTreeNode item,ConnTreeNode parent,boolean select){addItem(item,list.indexOf(parent)+1,select);}
	public void addItem(ConnTreeNode item,int index,boolean selectNewNode){
		if(item==null) throw new NullPointerException();
		list.add(index,item);
		if(selectNewNode) select(index);
		else if(selected >=index) select(selected+1);
		notifySizeChange();
	}

	public void removeItem(int index){
		if(index <0 || index>= list.size()) return;
		int old_selected = selected;
		selected=-1;
		list.remove(index);
		if(old_selected == index ){
			select(index==list.size()?index-1:index);
		}else if( old_selected > index ){
			select(old_selected-1);
		}
		notifySizeChange();
	}
	public void removeItem(ConnTreeNode item){removeItem(list.indexOf(item));}

	public int getSelectedIndex(){ return selected;}
	public ConnTreeNode getSelected(){ return getItem(selected); }
	public void select(ConnTreeNode node){ select( list.indexOf(node) ); }
	public void select(int index){
		if(selected==index || index<0 || index >=list.size() ) return;
		selected=index;
		SwingUtilities.invokeLater(new Runnable(){public void run(){
			sub_scrollRectToVisible();
		}});
		// 選択が変わったことを通知する
		ConnTreeNode item = getItem(selected);
		if(item!=null) item.OnSelect();
		App.getApp().updateTopic();
		repaint(300);
	}
	public void StepScroll(int i,boolean loop){
		int count = App.buf_list.getCount();
		int now = App.buf_list.getSelectedIndex();
		i=(now<0?0:now+i);
		if(!loop){
			select(i<0?0:i>=count?count-1:i);
			return;
		}
		while(i<0) i+=count;
		select( i%count );
	}
	public void sub_scrollRectToVisible(){
		if(selected >=0) scrollRectToVisible(new Rectangle(0,line_height * selected,1,line_height));
	}
	// 選択されている項目またはその親を返す
	public CTN_Conn getConn		(){ConnTreeNode c=getSelected();return (c==null)?null:c.getConnNode();}
	public CTN_Chan getChannel	(){ConnTreeNode c=getSelected();return (c==null)?null:c.getChannelNode();}
	public CTN_Priv getPrivNode	(){ConnTreeNode c=getSelected();return (c==null)?null:c.getPrivNode();}

	// サイズの変更はないが再描画を行う
	public void redrawItem(ConnTreeNode item){ repaint(300,0,line_height*list.indexOf(item),getWidth(),line_height); }
	// コンポーネントのサイズの変更をビューポートに伝える
	public void notifySizeChange(){
		repaint(300);
		invalidate();
		revalidate();
		SwingUtilities.invokeLater(new Runnable(){public void run(){
			sub_scrollRectToVisible();
		}});
	}

	///////////////////////////////
	// ソートと順序の記憶/リストア

	public void sortItem(){ 
		if(list.size()<=1) return;
		select(1);
		ConnTreeNode.sort_type=0;
		Collections.sort(list);
		select(0);
		repaint(300);
	}
	public void sortByOrder(){
		if(list.size()<=1) return;
		select(1);
		ConnTreeNode.sort_type=1;
		Collections.sort(list);
		select(0);
		repaint(300);
	}
	void saveOrder(){
		int i=0;
		for(Iterator it = list.listIterator(0);it.hasNext();){
			ConnTreeNode item =(ConnTreeNode)it.next();
			item.property.setInt("order_in_list",++i);
		}
	}
	// ある項目の順序を入れ替える
	public void changeOrder(int from,int to){
		if(from==to 
		|| from<0 || from>=list.size() 
		|| to<0 || to >=list.size()
		)  return;

		list.add(to,list.remove(from));
		if(selected == from) selected=to;
		repaint(300);
	}

// falseのままでいいか	public boolean isRequestFocusEnabled(){ return true;}

	/////////////////////////////
	// マウス操作、DnD による順番の入れ替え

	int drug_from=-1;
	int drug_to;
	public BufferList(){
/*
		DropTargetListener target_listen = new DropTargetListener() {
			// エリアに入った
			public void dragEnter(DropTargetDragEvent e){ check_drop(e); }
			// エリア内で動いた
			public void dragOver(DropTargetDragEvent e){ check_drop(e); }
			// エリアから出た
			public void dragExit(DropTargetEvent e){ check_drop(null); }
			// 置いた
			public void drop(DropTargetDropEvent e){
				 System.out.println("DropTarget: #drop");
			}
			// ユーザがCOPY,MOVEの種類を変えた
			public void dropActionChanged(DropTargetDragEvent e){
				 System.out.println("DropTarget: #dragActionChanged");
			}
		};
		DropTarget target = new DropTarget(this, target_listen);
*/

/*

		DragSource source = DragSource.getDefaultDragSource();
		final DragSourceListener source_listen = new DragSourceListener() {
			public void dragEnter(DragSourceDragEvent e) {System.out.println("DragSource: #dragEnter");}
			public void dragOver(DragSourceDragEvent e) {}
			public void dragExit(DragSourceEvent e) {System.out.println("DragSource: #dragExit");}
			public void dropActionChanged(DragSourceDragEvent e) {System.out.println("DragSource: #dropActionChanged");}
			public void dragDropEnd(DragSourceDropEvent e){System.out.println("DragSource: #dragDropEnd");}
		};

		source.createDefaultDragGestureRecognizer(
			this,DnDConstants.ACTION_COPY_OR_MOVE,
			new DragGestureListener() {
				public void dragGestureRecognized(DragGestureEvent e) {
					e.startDrag(DragSource.DefaultMoveDrop,
						new StringSelection(getName()),
						source_listen);
			}
		});
*/

		addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent e){
				drug_from = -1;
				int index = pointItemAt(e,false);
				if(index != -1){
					select(index);
					ConnTreeNode item = (ConnTreeNode)list.get(index);
					item.onClick(e);
				}
			}
			public void mousePressed(MouseEvent e){
				if( e.isPopupTrigger() ){
					int index = pointItemAt(e,false);
					if(index != -1){
						select(index);
						ConnTreeNode item = (ConnTreeNode)list.get(index);
						App.menu_conf.showPopupMenu(e,item.getPopupName());
					}
				}
				drug_from = pointItemAt(e,false);
				if(drug_from!=-1){
					select(drug_from);
					drug_to = -2;
				//	logger.finer("drag start");
				//	getTransferHandler().exportAsDrag((JComponent)e.getComponent(), e, TransferHandler.COPY);
				}
			}
			public void mouseReleased(MouseEvent e){
				if( e.isPopupTrigger() ){
					int index = pointItemAt(e,false);
					if(index != -1){
						select(index);
						ConnTreeNode item = (ConnTreeNode)list.get(index);
						String menu = item.getPopupName();
						App.menu_conf.showPopupMenu(e,menu);
					}
				}
				if( drug_from!=-1 ){
					changeOrder(drug_from,drug_to);
					drug_from = -1;
					setCursor( java.awt.Cursor.getPredefinedCursor(java.awt.Cursor.DEFAULT_CURSOR) );
					repaint(300);
				}
			}
		});
		addMouseMotionListener(new MouseMotionAdapter(){
			public void mouseDragged(MouseEvent e){
			//	logger.finer("mouseDragged from="+drug_from);
				if(drug_from!=-1){
				//	setCursor( java.awt.Cursor.getPredefinedCursor(java.awt.Cursor.HAND_CURSOR ) );
					drug_to = pointItemAt(e,true);
					repaint(300);
				}
			}
		});
		addKeyListener(new KeyListener(){
			public void keyPressed(KeyEvent e){
				switch(e.getKeyCode() ){
				case KeyEvent.VK_UP:   
				case KeyEvent.VK_KP_UP:   StepScroll(-1,true); return;
				case KeyEvent.VK_DOWN: 
				case KeyEvent.VK_KP_DOWN: StepScroll( 1,true); return;
				case KeyEvent.VK_PAGE_UP:   StepScroll(-getHeight()/line_height,false); return;
				case KeyEvent.VK_PAGE_DOWN: StepScroll( getHeight()/line_height,false); return;
				}
			//	System.out.println("LogView:keyPressed:"+e);
			}
			public void keyReleased(KeyEvent e){
			}
			public void keyTyped(KeyEvent e){
			//	System.out.println("LogView:keyTyped:"+e);
			}
		});
		setTransferHandler(new BufferListTransferHandler(this));
	}

	//////////////////////////////////////////
	// サイズの測定、描画、クリック位置の検出

	FontInfo fiL1;
	FontInfo fiL2;
	FontInfo fiNum;
	void setFontInfo(FontInfo fiL1,FontInfo fiL2,FontInfo fiNum){
		this.fiL1=fiL1;
		this.fiL2=fiL2;
		this.fiNum=fiNum;
		notifySizeChange();
	}

	FontMetrics fmL1;
	FontMetrics fmL2;
	FontMetrics fmNum;
	int number_width;
	int font_offset;
	int icon_offset;

	public Dimension getPreferredSize(){
		if(fiL1==null) return new Dimension(10,10);
		fmL1   = getFontMetrics(fiL1.font);
		fmL2   = getFontMetrics(fiL2.font);
		fmNum  = getFontMetrics(fiNum.font);

		int ascent=0;
		int descent=0;
		int leading=0;
		FontMetrics[] fm_list = new FontMetrics[]{ fmL1,fmL2,fmNum};
		for(int i=0;i<fm_list.length;++i){
			if(ascent<fm_list[i].getAscent())   ascent = fm_list[i].getAscent();
			if(descent<fm_list[i].getDescent()) descent = fm_list[i].getDescent();
			if(leading<fm_list[i].getLeading()) leading = fm_list[i].getLeading();
		}
		int icon_max_height=0;
		for(Iterator it = list.listIterator(0);it.hasNext();){
			ConnTreeNode item =(ConnTreeNode)it.next();
			ImageIcon icon = item.getImageIcon();
			if(icon!=null){
				int h = icon.getIconHeight();
				if(icon_max_height<h) icon_max_height=h;
			}
		}
		if(ascent+descent+leading < icon_max_height){
			leading += (icon_max_height-(ascent+descent+leading))/2;
			descent =icon_max_height-(ascent+leading);
		}
		line_height = ascent+descent+leading;
		font_offset = (ascent+leading);
		icon_offset = (ascent+leading)-icon_max_height;

		// インデクス表示の幅の最大
		number_width=0;
		for(int i=0;i<list.size();++i){
			int w=fmNum.stringWidth(Integer.toString(i));
			if(number_width<w) number_width=w;
		}

		int xmax=0;
		for(Iterator it = list.listIterator(0);it.hasNext();){
			ConnTreeNode item =(ConnTreeNode)it.next();
			int x=0;
			ImageIcon icon = item.getImageIcon();
			if(icon!=null){
				int w = icon.getIconWidth();
				if(w>0){
					// add offset and icon size
					x+=w+w/4*item.getListOffset();
				}
			}
			x+= 2 + fmL1.stringWidth(item.getListLabel1())
			  + 4 + fmL2.stringWidth(item.getListLabel2()) +4 ;
			if(xmax<x)xmax=x;
		}
		return new Dimension(number_width+1+xmax,line_height*list.size()+1);
	}

	public void paint(Graphics g){
		Rectangle r=g.getClipBounds();
		int view_end=getWidth();
		if(view_end > r.x+r.width) view_end=r.x+r.width;

		if(fiL1.bg!=null){
			g.setColor(fiL1.bg);
			g.fillRect(r.x,r.y,r.width,r.height);
		}
		// draw number
		{
			g.setColor(fiNum.fg);
			g.setFont(fiNum.font);
			int i=0;
			for(Iterator it = list.listIterator(0);it.hasNext();++i){
				ConnTreeNode item =(ConnTreeNode)it.next();
				int y= i*line_height;
				if(y>=r.y+r.height) break;
				if(y+line_height<=r.y) continue;
				{
					String s = Integer.toString(i);
					g.drawString( s,number_width-fmNum.stringWidth(s),y+font_offset);
				}
			}
		}
		int i=0;
		for(Iterator it = list.listIterator(0);it.hasNext();++i){
			ConnTreeNode item =(ConnTreeNode)it.next();
			int y= i*line_height;
			if(y>=r.y+r.height) break;
			if(y+line_height<=r.y) continue;
			ImageIcon icon = item.getImageIcon();
			int x      =number_width+1;
			int xstart =number_width+1;
			Image image=null;
			if(icon!=null){
				int w = icon.getIconWidth();
				if(w>0){
					// add offset
					x += w/4*item.getListOffset();
					xstart=x;
					x+=w;
					image = icon.getImage();
				}
			}
			x+=2;
			// draw label1
			{
				int w=fmL1.stringWidth(item.getListLabel1());
				g.setFont(fiL1.font);
				if(selected == i){
					g.setColor(fiL1.bg2);
					g.fillRect(xstart-1,y,x+w+2-xstart,line_height);
					g.setColor(fiL1.fg2);
				}else{
					g.setColor(fiL1.fg);
				}
				g.drawString( item.getListLabel1(),x,y+font_offset);
				if(drug_from ==i && drug_to != -2){
					g.setColor(fiL2.bg);
					g.drawRect(xstart-1,y,x+w+2-xstart,line_height);
				}
				if(image!=null) g.drawImage(image,xstart,y,this);
				x += w;
			}
			// draw label2
			{
				int w= fmL2.stringWidth(item.getListLabel2());
				x+=4;
				if(view_end-x >w) x = view_end-w;
				g.setFont(fiL2.font);
				g.setColor(fiL2.fg);
				g.drawString( item.getListLabel2(),x,y+font_offset);
			}
		}
		if(drug_from!=-1 && drug_to >=0 && drug_from!=drug_to){
			int line_pos = drug_to;
			if(drug_to > drug_from) ++line_pos;
			int y= line_pos * line_height;
			g.setColor(fiL2.bg);
			g.fillRect(0,y-1,view_end,2);
		}
	}
	int pointItemAt(MouseEvent e,boolean moveto){
		return pointItemAt(new Point(e.getX(),e.getY()),moveto);
	}

	int pointItemAt(Point e,boolean moveto){
		int index = e.y/line_height;
		if(index <0) return moveto?0:-1;
		if(index >=list.size()) return moveto?list.size()-1:-1;
		if(moveto) return index;
		ConnTreeNode item =(ConnTreeNode)list.get(index);
		{
			int x=number_width+1;
			int xstart = x;
			ImageIcon icon = item.getImageIcon();
			if(icon!=null){
				int w = icon.getIconWidth();
				if(w>0){
					// add offset
					x+=w/4*item.getListOffset();
					xstart = x;
					x+=w;
				}
			}
			x+=2;
			// draw label
			{
				int w=fmL1.stringWidth(item.getListLabel1());
				x += w;
			}
			if(e.x >= xstart && e.getX() <x ) return index;
		}
		return -1;
	}
}

// Transferableを指定するハンドラ
class BufferListTransferHandler extends TransferHandler{
	private static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("bluntirc.bufferlisttransferhandler");
	static{ logger.setLevel(null); }

	BufferList t;
	public BufferListTransferHandler(BufferList t){super();this.t=t; }

	public int getSourceActions(JComponent c){ return COPY_OR_MOVE; }
	protected Transferable createTransferable(JComponent c){ return t; }

	public static Action getCutAction(){
		logger.finer("getCutAction called");
		return null;
	}
	public static Action getCopyAction(){
		logger.finer("getCopyAction called");
		return null;
	}
	public static Action getPasteAction(){
		logger.finer("getPasteAction called");
		return null;
	}

/*
	public void exportAsDrag(JComponent comp,InputEvent e,int action){
		super.exportAsDrag(comp,e,action);
		logger.finer("exportAsDrag called");
	}
	public void exportToClipboard
	(JComponent comp,java.awt.datatransfer.Clipboard clip,int action){
		super.exportToClipboard(comp,clip,action);
		logger.finer("exportToClipboard called");
	}
	public Icon getVisualRepresentation(java.awt.datatransfer.Transferable t){
		Icon result = super.getVisualRepresentation(t);
		logger.finer("getVisualRepresentation called");
		return result;
	}
*/
	protected void exportDone(JComponent source,java.awt.datatransfer.Transferable data,int action){
		logger.finer("exportDone called");
		t.exportDone();
	}

	public boolean canImport
	(JComponent comp,DataFlavor[] transferFlavors){
		if(t!=comp ) return false;
		for(int i=0;i<transferFlavors.length;++i){
			if(t.canDrop(transferFlavors[i])) return true;
		}
		return false;
	}
	public boolean importData(JComponent comp,Transferable t){
	//	boolean result = super.importData(comp,t);
		logger.finer("importData called");
		return false;
	}
}
