// UTF-8 ☀☁☂☃

package action;

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import bluntirc.*;
import irc.*;
import base.*;
import gui.*;

public class ConnectionAndTarget{
	public ConnTreeNode node;
	public Object[] target;

	public CTN_Conn getConnectionNode(){ return node.getConnNode(); }
	public CTN_Chan getChannelNode(){ return node.getChannelNode(); }
	public CTN_Priv getPrivateNode(){ return node.getPrivNode(); }

	public IRCChannelNameOrPrefix StringToTarget(String s){
		if(s==null) return null;
		IRCConnection conn = getConnectionNode().conn;
		int i=0;while(i<s.length() && s.charAt(i)<=' ') ++i;
		int start=i;while(i<s.length() && s.charAt(i)>' ') ++i;
		s= s.substring(start,i);
		if(s.length()==0) return null;
		if(irc.IRCChannelName.isChannelName(s.charAt(0))){
			IRCChannelName cname = new IRCChannelName(s);
			// 類似するチャンネル名があればそれを使う
			IRCChannel chan = conn.findChannelAmbiguous(cname);
			if(chan!=null) return chan;
			// なければ指定された名前を使う
			return cname;
		}
		i=0;while(i<s.length() && s.charAt(i)!='!') ++i;
		return conn.findUser(Util.toJIS(s.substring(0,i)));
	}

	public void init(ActionEvent e,Component invoker){
		// メンバ一覧
		if(invoker instanceof gui.MyTable){
			LinkedList users = App.main_window.user_view.getSelectedMulti();
			if(users!=null){
				target = new Object[users.size()];
				int i=0;
				for(Iterator it=users.iterator();it.hasNext();++i){
					target[i]=it.next();
				}
			}else{
				target = new Object[0];
			}
			node = App.getSelected();
			return;
		}
		// バッファ一覧
		if(invoker instanceof bluntirc.BufferList){
			node = App.buf_list.getSelected();
			if(node!=null) target= new Object[]{node};
			return;
		}
		// バッファ
		if(invoker instanceof buffer.LogView){
			buffer.TextSpanInfo info = ActionUtility.getLastHover(e);
			init(ActionUtility.getContextNode(info),info.text);
			return;
		}
		App.Log("unknown invoker "+invoker.getClass().getName());
	}

	public void init(ConnTreeNode node,String target){
		this.node=node;
		if(node!=null) this.target=new Object[]{StringToTarget(target)};
	}
	public ConnectionAndTarget(ConnTreeNode node,Object target){
		this.node=node;
		this.target=new Object[]{target};
	}

	// アクションから接続とターゲットを読み取る{
	public ConnectionAndTarget(ActionEvent e){
		Object o=App.action_manager.getStackParameter();

		// コマンド入力の場合
		if(o instanceof String){
			init(App.getSelected(),(String)o); 
			return;
		}

		// バッファ内の区間のクリックの場合
		if(o instanceof Object[]){
			Object[] arg = (Object[]) o;
			MouseEvent ee        =(MouseEvent)arg[0];
			buffer.LogDocument document =(buffer.LogDocument)arg[1];
			buffer.TextSpanInfo pos     =(buffer.TextSpanInfo)arg[2];
			if(ee.getClickCount()!=2) return;
			init( ActionUtility.getContextNode(pos),pos.text);
			return;
		}

		o= e.getSource();

		// メニューから呼ばれた場合
		if(o instanceof JMenuItem){
			// ポップアップメニューは自分がどこに表示されるか知っているはずだから、
			//それを利用すればどのコンポーネントの選択状態を読めばいいかわかるはずだ
			for(;;){
				// 追跡できなかった
				if(o==null || (o instanceof JMenuBar)) break;

				// JMenu の場合、プロパティでinvokerが指定されているかもしれない
				if(o instanceof JMenu){
					String s = (String)((JMenu)o).getClientProperty("action_invoker");
					if(s!=null){
						if(s.equals("members")){ init(e,App.main_window.user_view.table);return;}
						if(s.equals("buffer_list")){ init(e,App.buf_list);return;}
						App.Log("メニューに指定されたinvokerの"+s+"が変");
						return;
					}
				}

				// 親コンポーネント
				Component c = ((Component)o).getParent();
				if(c!=null && (o instanceof JMenuItem)){ o=c; continue; }

				if(o instanceof JPopupMenu){
					JPopupMenu pm=(JPopupMenu)o;
					if(c==null) c = pm.getInvoker();
					if( !(c instanceof JMenu)
					&&  !(c instanceof JPopupMenu)
					){
						init(e,c);
						return;
					}
				}
				o=c;
			}
		}
		App.Log("e.getSource "+o.getClass().getName());
	}
}
