/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EmptyStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InnerClassAllocation;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnaryExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;

public class DisplayVisitor
extends VisitorObject {
    private PrintStream out;
    private String indentation;

    public DisplayVisitor(OutputStream os) {
        this.out = new PrintStream(os);
        this.indentation = "";
    }

    public Object visit(PackageDeclaration node) {
        this.print("l." + node.getBeginLine() + " PackageDeclaration " + node.getName() + " {");
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ImportDeclaration node) {
        this.print("l." + node.getBeginLine() + " ImportDeclaration " + node.getName() + (node.isPackage() ? ".*" : "") + " {");
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(EmptyStatement node) {
        this.print("l." + node.getBeginLine() + " EmptyStatement {");
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(WhileStatement node) {
        this.print("l." + node.getBeginLine() + " WhileStatement {");
        this.print("condition:");
        this.indent();
        node.getCondition().acceptVisitor(this);
        this.unindent();
        this.print("body:");
        this.indent();
        node.getBody().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ForStatement node) {
        Iterator it;
        this.print("l." + node.getBeginLine() + " ForStatement {");
        this.print("initialization:");
        if (node.getInitialization() != null) {
            this.indent();
            it = node.getInitialization().iterator();
            while (it.hasNext()) {
                ((Node)it.next()).acceptVisitor(this);
            }
            this.unindent();
        }
        this.print("condition:");
        if (node.getCondition() != null) {
            this.indent();
            node.getCondition().acceptVisitor(this);
            this.unindent();
        }
        this.print("update:");
        if (node.getUpdate() != null) {
            this.indent();
            it = node.getUpdate().iterator();
            while (it.hasNext()) {
                ((Node)it.next()).acceptVisitor(this);
            }
            this.unindent();
        }
        this.print("body:");
        this.indent();
        node.getBody().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(DoStatement node) {
        this.print("l." + node.getBeginLine() + " DoStatement {");
        this.print("condition:");
        this.indent();
        node.getCondition().acceptVisitor(this);
        this.unindent();
        this.print("body:");
        this.indent();
        node.getBody().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(SwitchStatement node) {
        this.print("l." + node.getBeginLine() + " SwitchStatement {");
        this.print("selector:");
        this.indent();
        node.getSelector().acceptVisitor(this);
        this.unindent();
        this.print("bindings:");
        this.indent();
        Iterator it = node.getBindings().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(SwitchBlock node) {
        this.print("l." + node.getBeginLine() + " SwitchBlock {");
        this.print("expression:");
        this.indent();
        if (node.getExpression() != null) {
            node.getExpression().acceptVisitor(this);
        } else {
            this.print("default");
        }
        this.unindent();
        this.print("statements:");
        this.indent();
        if (node.getStatements() != null) {
            Iterator it = node.getStatements().iterator();
            while (it.hasNext()) {
                ((Node)it.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(LabeledStatement node) {
        this.print("l." + node.getBeginLine() + " LabeledStatement {");
        this.print("label:");
        this.indent();
        this.print(node.getLabel());
        this.unindent();
        this.print("statement:");
        this.indent();
        node.getStatement().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(BreakStatement node) {
        this.print("l." + node.getBeginLine() + " BreakStatement {");
        this.print("label:");
        this.indent();
        this.print(node.getLabel());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(TryStatement node) {
        this.print("l." + node.getBeginLine() + " TryStatement {");
        this.print("tryBlock:");
        this.indent();
        node.getTryBlock().acceptVisitor(this);
        this.unindent();
        this.print("catchStatements:");
        this.indent();
        Iterator it = node.getCatchStatements().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("finallyBlock:");
        this.indent();
        if (node.getFinallyBlock() != null) {
            node.getFinallyBlock().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(CatchStatement node) {
        this.print("l." + node.getBeginLine() + " CatchStatement {");
        this.print("exception:");
        this.indent();
        node.getException().acceptVisitor(this);
        this.unindent();
        this.print("block:");
        this.indent();
        node.getBlock().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ThrowStatement node) {
        this.print("l." + node.getBeginLine() + " ThrowStatement {");
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ReturnStatement node) {
        this.print("l." + node.getBeginLine() + " ReturnStatement {");
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(SynchronizedStatement node) {
        this.print("l." + node.getBeginLine() + " SynchronizedStatement {");
        this.print("lock:");
        this.indent();
        node.getLock().acceptVisitor(this);
        this.unindent();
        this.print("body:");
        this.indent();
        node.getBody().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ContinueStatement node) {
        this.print("l." + node.getBeginLine() + " ContinueStatement {");
        this.print("label:");
        this.indent();
        this.print(node.getLabel());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(IfThenStatement node) {
        this.print("l." + node.getBeginLine() + " IfThenStatement {");
        this.print("condition:");
        this.indent();
        node.getCondition().acceptVisitor(this);
        this.unindent();
        this.print("thenStatement:");
        this.indent();
        node.getThenStatement().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(IfThenElseStatement node) {
        this.print("l." + node.getBeginLine() + " IfThenElseStatement {");
        this.print("condition:");
        this.indent();
        node.getCondition().acceptVisitor(this);
        this.unindent();
        this.print("thenStatement:");
        this.indent();
        node.getThenStatement().acceptVisitor(this);
        this.unindent();
        this.print("elseStatement:");
        this.indent();
        node.getElseStatement().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(Literal node) {
        this.print("l." + node.getBeginLine() + " Literal (" + node.getType() + ") <" + node.getValue() + "> {");
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ThisExpression node) {
        this.print("l." + node.getBeginLine() + " ThisExpression {");
        this.print("className:");
        this.indent();
        this.print(node.getClassName());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(QualifiedName node) {
        this.print("l." + node.getBeginLine() + " QualifiedName {");
        this.print("representation:");
        this.indent();
        this.print(node.getRepresentation());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ObjectFieldAccess node) {
        this.print("l." + node.getBeginLine() + " ObjectFieldAccess {");
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("fieldName:");
        this.indent();
        this.print(node.getFieldName());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(StaticFieldAccess node) {
        this.print("l." + node.getBeginLine() + " StaticFieldAccess {");
        this.print("fieldType:");
        this.indent();
        node.getFieldType().acceptVisitor(this);
        this.unindent();
        this.print("fieldName:");
        this.indent();
        this.print(node.getFieldName());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ArrayAccess node) {
        this.print("l." + node.getBeginLine() + " ArrayAccess {");
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("cellNumber:");
        this.indent();
        node.getCellNumber().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(SuperFieldAccess node) {
        this.print(this.indentation + "l." + node.getBeginLine() + " SuperFieldAccess {");
        this.print("fieldName:");
        this.indent();
        this.print(node.getFieldName());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ObjectMethodCall node) {
        this.print("l." + node.getBeginLine() + " ObjectMethodCall {");
        this.print("expression:");
        this.indent();
        if (node.getExpression() != null) {
            node.getExpression().acceptVisitor(this);
        } else {
            this.print("null");
        }
        this.unindent();
        this.print("methodName:");
        this.indent();
        this.print(node.getMethodName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator it = node.getArguments().iterator();
            while (it.hasNext()) {
                ((Expression)it.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(FunctionCall node) {
        this.print("l." + node.getBeginLine() + " FunctionCall {");
        this.print("methodName:");
        this.indent();
        this.print(node.getMethodName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator it = node.getArguments().iterator();
            while (it.hasNext()) {
                ((Expression)it.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(StaticMethodCall node) {
        this.print("l." + node.getBeginLine() + " StaticMethodCall {");
        this.print("methodType:");
        this.indent();
        node.getMethodType().acceptVisitor(this);
        this.unindent();
        this.print("methodName:");
        this.indent();
        this.print(node.getMethodName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator it = node.getArguments().iterator();
            while (it.hasNext()) {
                ((Expression)it.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ConstructorInvocation node) {
        this.print("l." + node.getBeginLine() + " ConstructorInvocation {");
        this.print("expression:");
        this.indent();
        if (node.getExpression() != null) {
            node.getExpression().acceptVisitor(this);
        }
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator it = node.getArguments().iterator();
            while (it.hasNext()) {
                ((Expression)it.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.print("isSuper:");
        this.indent();
        this.print(node.isSuper() ? "true" : "false");
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(SuperMethodCall node) {
        this.print("l." + node.getBeginLine() + " SuperMethodCall {");
        this.print("methodName:");
        this.indent();
        this.print(node.getMethodName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator it = node.getArguments().iterator();
            while (it.hasNext()) {
                ((Expression)it.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(PrimitiveType node) {
        this.print("l." + node.getBeginLine() + " PrimitiveType <" + node.getValue() + ">");
        this.displayProperties(node);
        return null;
    }

    public Object visit(ReferenceType node) {
        this.print("l." + node.getBeginLine() + " ReferenceType {");
        this.print("representation:");
        this.indent();
        this.print(node.getRepresentation());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ArrayType node) {
        this.print("l." + node.getBeginLine() + " ArrayType {");
        if (node.getElementType() != null) {
            this.print("elementType:");
            node.getElementType().acceptVisitor(this);
        }
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(TypeExpression node) {
        this.print("l." + node.getBeginLine() + " TypeExpression {");
        this.print("type:");
        this.indent();
        node.getType().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(PostIncrement node) {
        this.displayUnary(node);
        return null;
    }

    public Object visit(PostDecrement node) {
        this.displayUnary(node);
        return null;
    }

    public Object visit(PreIncrement node) {
        this.displayUnary(node);
        return null;
    }

    public Object visit(PreDecrement node) {
        this.displayUnary(node);
        return null;
    }

    public Object visit(ArrayInitializer node) {
        this.print("l." + node.getBeginLine() + " ArrayInitializer {");
        this.print("cells:");
        this.indent();
        Iterator it = node.getCells().iterator();
        while (it.hasNext()) {
            ((Expression)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("elementType:");
        this.indent();
        node.getElementType().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ArrayAllocation node) {
        this.print("l." + node.getBeginLine() + " ArrayAllocation {");
        this.print("creationType:");
        this.indent();
        node.getCreationType().acceptVisitor(this);
        this.unindent();
        this.print("dimension:");
        this.indent();
        this.print("" + node.getDimension());
        this.unindent();
        this.print("sizes:");
        this.indent();
        Iterator it = node.getSizes().iterator();
        while (it.hasNext()) {
            ((Expression)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("initialization:");
        this.indent();
        if (node.getInitialization() != null) {
            node.getInitialization().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(SimpleAllocation node) {
        this.print("l." + node.getBeginLine() + " SimpleAllocation {");
        this.print("creationType:");
        this.indent();
        node.getCreationType().acceptVisitor(this);
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator it = node.getArguments().iterator();
            while (it.hasNext()) {
                ((Expression)it.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ClassAllocation node) {
        Iterator it;
        this.print("l." + node.getBeginLine() + " ClassAllocation {");
        this.print("creationType:");
        this.indent();
        node.getCreationType().acceptVisitor(this);
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            it = node.getArguments().iterator();
            while (it.hasNext()) {
                ((Expression)it.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.print("members:");
        this.indent();
        it = node.getMembers().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(InnerAllocation node) {
        this.print("l." + node.getBeginLine() + " InnerAllocation {");
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("creationType:");
        this.indent();
        node.getCreationType().acceptVisitor(this);
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator it = node.getArguments().iterator();
            while (it.hasNext()) {
                ((Expression)it.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(InnerClassAllocation node) {
        Iterator it;
        this.print("l." + node.getBeginLine() + " InnerClassAllocation {");
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("creationType:");
        this.indent();
        node.getCreationType().acceptVisitor(this);
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            it = node.getArguments().iterator();
            while (it.hasNext()) {
                ((Expression)it.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.print("members:");
        this.indent();
        it = node.getMembers().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(CastExpression node) {
        this.print("l." + node.getBeginLine() + " CastExpression {");
        this.print("targetType:");
        this.indent();
        node.getTargetType().acceptVisitor(this);
        this.unindent();
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(NotExpression node) {
        this.displayUnary(node);
        return null;
    }

    public Object visit(ComplementExpression node) {
        this.displayUnary(node);
        return null;
    }

    public Object visit(PlusExpression node) {
        this.displayUnary(node);
        return null;
    }

    public Object visit(MinusExpression node) {
        this.displayUnary(node);
        return null;
    }

    public Object visit(MultiplyExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(DivideExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(RemainderExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(AddExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(SubtractExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(ShiftLeftExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(ShiftRightExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(UnsignedShiftRightExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(LessExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(GreaterExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(LessOrEqualExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(GreaterOrEqualExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(InstanceOfExpression node) {
        this.print("l." + node.getBeginLine() + " InstanceOfExpression {");
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("referenceType:");
        this.indent();
        node.getReferenceType().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(EqualExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(NotEqualExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(BitAndExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(ExclusiveOrExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(BitOrExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(AndExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(OrExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(ConditionalExpression node) {
        this.print("l." + node.getBeginLine() + " ConditionalExpression {");
        this.print("conditionExpression:");
        this.indent();
        node.getConditionExpression().acceptVisitor(this);
        this.unindent();
        this.print("ifTrueExpression:");
        this.indent();
        node.getIfTrueExpression().acceptVisitor(this);
        this.unindent();
        this.print("ifFalseExpression:");
        this.indent();
        node.getIfFalseExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(SimpleAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(MultiplyAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(DivideAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(RemainderAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(AddAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(SubtractAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(ShiftLeftAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(ShiftRightAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(UnsignedShiftRightAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(BitAndAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(ExclusiveOrAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(BitOrAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    public Object visit(BlockStatement node) {
        this.print("l." + node.getBeginLine() + " BlockStatement {");
        this.print("statements:");
        this.indent();
        Iterator it = node.getStatements().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ClassDeclaration node) {
        Iterator it;
        this.print("l." + node.getBeginLine() + " ClassDeclaration {");
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.print("superclass:");
        this.indent();
        this.print(node.getSuperclass());
        this.unindent();
        this.print("interfaces:");
        this.indent();
        if (node.getInterfaces() != null) {
            it = node.getInterfaces().iterator();
            while (it.hasNext()) {
                this.print((String)it.next());
            }
        }
        this.unindent();
        this.print("members:");
        this.indent();
        it = node.getMembers().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(InterfaceDeclaration node) {
        Iterator it;
        this.print("l." + node.getBeginLine() + " InterfaceDeclaration {");
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.print("interfaces:");
        this.indent();
        if (node.getInterfaces() != null) {
            it = node.getInterfaces().iterator();
            while (it.hasNext()) {
                this.print((String)it.next());
            }
        }
        this.unindent();
        this.print("members:");
        this.indent();
        it = node.getMembers().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ConstructorDeclaration node) {
        this.print("l." + node.getBeginLine() + " ConstructorDeclaration {");
        this.print("accessFlags:");
        this.indent();
        this.print("" + node.getAccessFlags());
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.print("parameters:");
        this.indent();
        Iterator it = node.getParameters().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("exceptions:");
        this.indent();
        it = node.getExceptions().iterator();
        while (it.hasNext()) {
            this.print((String)it.next());
        }
        this.unindent();
        this.print("constructorInvocation:");
        this.indent();
        if (node.getConstructorInvocation() != null) {
            node.getConstructorInvocation().acceptVisitor(this);
        }
        this.unindent();
        this.print("statements:");
        this.indent();
        it = node.getStatements().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(MethodDeclaration node) {
        this.print("l." + node.getBeginLine() + " MethodDeclaration {");
        this.print("accessFlags:");
        this.indent();
        this.print("" + node.getAccessFlags());
        this.unindent();
        this.print("returnType:");
        this.indent();
        node.getReturnType().acceptVisitor(this);
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.print("parameters:");
        this.indent();
        Iterator it = node.getParameters().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("exceptions:");
        this.indent();
        it = node.getExceptions().iterator();
        while (it.hasNext()) {
            this.print((String)it.next());
        }
        this.unindent();
        this.print("body:");
        this.indent();
        if (node.getBody() != null) {
            node.getBody().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(FormalParameter node) {
        this.print("l." + node.getBeginLine() + " FormalParameter {");
        if (node.isFinal()) {
            this.print("final");
        }
        this.print("type:");
        this.indent();
        node.getType().acceptVisitor(this);
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(FieldDeclaration node) {
        this.print("l." + node.getBeginLine() + " FieldDeclaration {");
        this.print("accessFlags:");
        this.indent();
        this.print("" + node.getAccessFlags());
        this.unindent();
        this.print("type:");
        this.indent();
        node.getType().acceptVisitor(this);
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.print("initializer:");
        this.indent();
        if (node.getInitializer() != null) {
            node.getInitializer().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(VariableDeclaration node) {
        this.print("l." + node.getBeginLine() + " VariableDeclaration {");
        this.print("isFinal:");
        this.indent();
        this.print("" + node.isFinal());
        this.unindent();
        this.print("type:");
        this.indent();
        node.getType().acceptVisitor(this);
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.print("initializer:");
        this.indent();
        if (node.getInitializer() != null) {
            node.getInitializer().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(ClassInitializer node) {
        this.print("l." + node.getBeginLine() + " ClassInitializer {");
        this.print("block:");
        this.indent();
        node.getBlock().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    public Object visit(InstanceInitializer node) {
        this.print("l." + node.getBeginLine() + " InstanceInitializer {");
        this.print("block:");
        this.indent();
        node.getBlock().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    private void displayUnary(UnaryExpression ue) {
        this.print("l." + ue.getBeginLine() + " " + ue.getClass().getName() + " {");
        this.print("expression:");
        this.indent();
        ue.getExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(ue);
        this.print("}");
    }

    private void displayBinary(BinaryExpression be) {
        this.print("l." + be.getBeginLine() + " " + be.getClass().getName() + " {");
        this.print("leftExpression:");
        this.indent();
        be.getLeftExpression().acceptVisitor(this);
        this.unindent();
        this.print("rightExpression:");
        this.indent();
        be.getRightExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(be);
        this.print("}");
    }

    private void displayProperties(Node node) {
        Iterator it = node.getProperties().iterator();
        if (it.hasNext()) {
            this.print("properties:");
        }
        while (it.hasNext()) {
            this.indent();
            String prop = (String)it.next();
            this.print(prop + ": " + node.getProperty(prop));
            this.unindent();
        }
    }

    private void indent() {
        this.indentation = this.indentation + "  ";
    }

    private void unindent() {
        this.indentation = this.indentation.substring(0, this.indentation.length() - 2);
    }

    private void print(String s) {
        this.out.println(this.indentation + s);
    }
}

