/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.tree.visitor.Visitor;

public abstract class Node {
    public static final String FILENAME = "filename";
    public static final String BEGIN_LINE = "beginLine";
    public static final String END_LINE = "endLine";
    public static final String BEGIN_COLUMN = "beginColumn";
    public static final String END_COLUMN = "endColumn";
    private String filename;
    private int beginLine;
    private int beginColumn;
    private int endLine;
    private int endColumn;
    private PropertyChangeSupport propertyChangeSupport;
    private Map properties;

    protected Node(String fn, int bl, int bc, int el, int ec) {
        this.filename = fn;
        this.beginLine = bl;
        this.beginColumn = bc;
        this.endLine = el;
        this.endColumn = ec;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.properties = new HashMap(11);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String s) {
        this.filename = s;
        this.firePropertyChange(FILENAME, this.filename, this.filename);
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public void setBeginLine(int i) {
        this.beginLine = i;
        this.firePropertyChange(BEGIN_LINE, this.beginLine, this.beginLine);
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public void setBeginColumn(int i) {
        this.beginColumn = i;
        this.firePropertyChange(BEGIN_COLUMN, this.beginColumn, this.beginColumn);
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int i) {
        this.endLine = i;
        this.firePropertyChange(END_LINE, this.endLine, this.endLine);
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int i) {
        this.endColumn = i;
        this.firePropertyChange(END_COLUMN, this.endColumn, this.endColumn);
    }

    public void setProperty(String name, Object value) {
        this.firePropertyChange(name, this.properties.put(name, value), value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Set getProperties() {
        return this.properties.keySet();
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public abstract Object acceptVisitor(Visitor var1);
}

