/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.List;
import koala.dynamicjava.tree.Allocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.visitor.Visitor;

public class ArrayAllocation
extends Allocation {
    private TypeDescriptor typeDescriptor;

    public ArrayAllocation(Type tp, TypeDescriptor td) {
        this(tp, td, null, 0, 0, 0, 0);
    }

    public ArrayAllocation(Type tp, TypeDescriptor td, String fn, int bl, int bc, int el, int ec) {
        super(tp, fn, bl, bc, el, ec);
        if (td == null) {
            throw new IllegalArgumentException("td == null");
        }
        this.typeDescriptor = td;
        td.initialize(tp);
    }

    public int getDimension() {
        return this.typeDescriptor.dimension;
    }

    public List getSizes() {
        return this.typeDescriptor.sizes;
    }

    public ArrayInitializer getInitialization() {
        return this.typeDescriptor.initialization;
    }

    public Object acceptVisitor(Visitor visitor) {
        return visitor.visit(this);
    }

    public static class TypeDescriptor {
        List sizes;
        int dimension;
        ArrayInitializer initialization;
        public int endLine;
        public int endColumn;

        public TypeDescriptor(List sizes, int dim, ArrayInitializer init, int el, int ec) {
            this.sizes = sizes;
            this.dimension = dim;
            this.initialization = init;
            this.endLine = el;
            this.endColumn = ec;
        }

        void initialize(Type t) {
            if (this.initialization != null) {
                Type et = this.dimension > 1 ? new ArrayType(t, this.dimension, t.getFilename(), t.getBeginLine(), t.getBeginColumn(), this.endLine, this.endColumn) : t;
                this.initialization.setElementType(et);
            }
        }
    }
}

